<?php
/**
 * The template part for displaying grid layout
 *
 * @package VW Corporate Lite 
 * @subpackage vw_corporate_lite
 * @since VW Corporate Lite 1.0
 */
?>
<?php 
  $vw_corporate_lite_archive_year  = get_the_time('Y'); 
  $vw_corporate_lite_archive_month = get_the_time('m'); 
  $vw_corporate_lite_archive_day   = get_the_time('d'); 
?>
<div class="col-lg-4 col-md-6">
  <article id="post-<?php the_ID(); ?>" <?php post_class('grid-post-main-box wow slideInLeft delay-1000'); ?>>
    <div class="services-box">
      <h2 class="section-title"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
      <?php if( get_theme_mod( 'vw_corporate_lite_grid_postdate',true) == 1 || get_theme_mod( 'vw_corporate_lite_grid_author',true) == 1 || get_theme_mod( 'vw_corporate_lite_grid_comments',true) == 1 || get_theme_mod( 'vw_corporate_lite_grid_time',true) == 1) { ?>
              <div class="post-info p-2 mb-3">
    	  <div class="metabox">
          <?php if(get_theme_mod('vw_corporate_lite_grid_postdate',true)==1){ ?>
            <span class="entry-date"><i class="<?php echo esc_attr(get_theme_mod('vw_corporate_lite_grid_postdate_icon','fas fa-calendar-alt')); ?>"></i><a href="<?php echo esc_url( get_day_link( $vw_corporate_lite_archive_year, $vw_corporate_lite_archive_month, $vw_corporate_lite_archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><span><?php echo esc_html(get_theme_mod('vw_corporate_lite_grid_post_meta_field_separator'));?></span>
          <?php } ?>

          <?php if(get_theme_mod('vw_corporate_lite_grid_author',true)==1){ ?>
            <i class="<?php echo esc_attr(get_theme_mod('vw_corporate_lite_grid_author_icon','far fa-user')); ?>"></i><span class="entry-author"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span><span><?php echo esc_html(get_theme_mod('vw_corporate_lite_grid_post_meta_field_separator'));?></span>
          <?php } ?>

          <?php if(get_theme_mod('vw_corporate_lite_grid_comments',true)==1){ ?>
            <i class="<?php echo esc_attr(get_theme_mod('vw_corporate_lite_grid_comments_icon','far fa-comments')); ?>"></i><span class="entry-comments"><?php comments_number( __('0 Comments','vw-corporate-lite'), __('0 Comments','vw-corporate-lite'), __('% Comments','vw-corporate-lite')); ?></span><span><?php echo esc_html(get_theme_mod('vw_corporate_lite_grid_post_meta_field_separator'));?></span>
          <?php } ?>

          <?php if(get_theme_mod('vw_corporate_lite_grid_time',true)==1){ ?>
                <i class="<?php echo esc_attr(get_theme_mod('vw_corporate_lite_grid_time_icon','fas fa-clock')); ?>"></i><span class="entry-time"><?php echo esc_html( get_the_time() ); ?></span>
          <?php } ?>
          <?php vw_corporate_lite_edit_link(); ?>
        </div>
    <?php } ?>
      <?php if( get_theme_mod( 'vw_corporate_lite_featured_image_hide_show',true) == 1) { ?>
        <div class="box-image">
          <?php 
            if(has_post_thumbnail()) { 
              the_post_thumbnail(); 
            }
          ?>	
        </div>
      <?php } ?>
      <div class="new-text">
        <div class="entry-content">
          <p>
            <?php $vw_corporate_lite_theme_lay = get_theme_mod( 'vw_corporate_lite_grid_excerpt_settings','Excerpt');
                        if($vw_corporate_lite_theme_lay == 'Content'){ ?>
                        <?php the_content(); ?>
                    <?php }
                      if($vw_corporate_lite_theme_lay == 'Excerpt'){ ?>
                        <?php if(get_the_excerpt()) { ?>
                          <?php $vw_corporate_lite_excerpt = get_the_excerpt(); echo esc_html( vw_corporate_lite_string_limit_words( $vw_corporate_lite_excerpt, esc_attr(get_theme_mod('vw_corporate_lite_related_posts_excerpt_number','30')))); ?> <?php echo esc_html( get_theme_mod('vw_corporate_lite_grid_excerpt_suffix','') ); ?>
                    <?php }?>
            <?php }?>       
          </p>
        </div>
      </div>
      <?php if( get_theme_mod('vw_corporate_lite_category_hide_show',true) == 1){ ?>	
      	<div class="cat-box">
          <i class="fas fa-folder-open"></i>
          <?php foreach((get_the_category()) as $category) { echo esc_html($category->cat_name) . ' '; } ?>
      	</div>
      <?php } ?>
    </div>	
    <div class="clearfix"></div>
  </article>
</div>