<?php
/**
 * Template Name: Custom Home
 */
get_header(); ?>

<main id="maincontent" role="main">
	<?php do_action( 'vw_corporate_lite_above_slider' ); ?>

	<?php if( get_theme_mod( 'vw_corporate_lite_slider_hide_show', false) == 1 || get_theme_mod( 'vw_corporate_lite_resp_slider_hide_show', true) == 1) { ?>
	  	<section class="slider">
	  		<?php if(get_theme_mod('vw_corporate_lite_slider_type', 'Default slider') == 'Default slider' ){ ?>
			   	<div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel" data-bs-interval="<?php echo esc_attr(get_theme_mod( 'vw_corporate_lite_slider_speed',4000)) ?>">  
			      <?php $vw_corporate_lite_slider_pages = array();
			        for ( $count = 1; $count <= 4; $count++ ) {
			          $mod = intval( get_theme_mod( 'vw_corporate_lite_slider_page' . $count ));
			          if ( 'page-none-selected' != $mod ) {
			            $vw_corporate_lite_slider_pages[] = $mod;
			          }
			        }
			        if( !empty($vw_corporate_lite_slider_pages) ) :
			          $args = array(
			            'post_type' => 'page',
			            'post__in' => $vw_corporate_lite_slider_pages,
			            'orderby' => 'post__in'
			          );
			          $query = new WP_Query( $args );
			          if ( $query->have_posts() ) :
			            $i = 1;
			      ?>     
			      <div class="carousel-inner" role="listbox">
			        <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
			          <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
			            <?php if(has_post_thumbnail()){
	                  the_post_thumbnail();
	                } else{?>
	                  <img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/block-patterns/images/slider.png" alt="" />
	                <?php } ?>
			            <div class="carousel-caption">
			              <div class="inner_carousel">
			                <h1 class="wow lightSpeedIn" data-wow-duration="2s"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
			                <p class="wow lightSpeedIn" data-wow-duration="2s"><?php $vw_corporate_lite_excerpt = get_the_excerpt(); echo esc_html( vw_corporate_lite_string_limit_words( $vw_corporate_lite_excerpt, esc_attr(get_theme_mod('vw_corporate_lite_slider_excerpt_number','30')))); ?></p>
			                <?php if( get_theme_mod('vw_corporate_lite_slider_button_text','READ MORE') != '' || get_theme_mod('vw_corporate_lite_slider_btn_link') != ''){ ?>
				                <div class="more-btn wow lightSpeedIn" data-wow-duration="2s">              
				                  <a href="<?php echo esc_url(get_theme_mod('vw_corporate_lite_slider_btn_link','')); ?>"><?php echo esc_html(get_theme_mod('vw_corporate_lite_slider_button_text',__('READ MORE','vw-corporate-lite')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_corporate_lite_slider_button_text',__('READ MORE','vw-corporate-lite')));?></span></a>
				                </div>
				            <?php } ?>
			              </div>
			            </div>
			          </div>
			        <?php $i++; endwhile; 
			        wp_reset_postdata();?>
			      </div>
			      <?php else : ?>
			          <div class="no-postfound"></div>
			        <?php endif;
			      endif;?>
			      <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
	                <span class="carousel-control-prev-icon w-auto h-auto" aria-hidden="true"><i class="fas fa-chevron-left"></i></span>
	                <span class="screen-reader-text"><?php esc_html_e( 'Previous','vw-corporate-lite' );?></span>
	              </a>
	              <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
	                <span class="carousel-control-next-icon w-auto h-auto" aria-hidden="true"><i class="fas fa-chevron-right"></i></span>
	                <span class="screen-reader-text"><?php esc_html_e( 'Next','vw-corporate-lite' );?></span>
	              </a>
			    </div>
		    	<div class="clearfix"></div>
    	  <?php } else if(get_theme_mod('vw_corporate_lite_slider_type', 'Advance slider') == 'Advance slider'){?>
          <?php echo do_shortcode(get_theme_mod('vw_corporate_lite_advance_slider_shortcode')); ?>
        <?php } ?>
	  	</section> 
	<?php }?>

	<?php do_action( 'vw_corporate_lite_below_slider' ); ?>

	<?php /*--OUR SERVICES--*/?>

	<?php if( get_theme_mod( 'vw_corporate_lite_sec1_title') != '' || get_theme_mod( 'vw_corporate_lite_sec1_subtitle' )!= ''){ ?>
		<section id="our-services" class="wow zoomInDown delay-1000" data-wow-duration="2s">
		    <div class="container">    	
			    <div class="innerlightbox">
			        <?php if( get_theme_mod('vw_corporate_lite_sec1_title') != ''){ ?>     
			            <h2><?php echo esc_html(get_theme_mod('vw_corporate_lite_sec1_title','')); ?></h2>
			        <?php }?>
			        <?php if( get_theme_mod('vw_corporate_lite_sec1_subtitle') != ''){ ?>
			        <div class="subtitle"><?php echo esc_html(get_theme_mod('vw_corporate_lite_sec1_subtitle','')); ?>
			        </div>
			        <?php }?>
			    </div>
			    <div class="row">
					<?php $vw_corporate_lite_service_page = array();
						for ( $count = 0; $count <= 2; $count++ ) {
							$mod = intval( get_theme_mod( 'vw_corporate_lite_servicesettings' . $count ));
							if ( 'page-none-selected' != $mod ) {
							  $vw_corporate_lite_service_page[] = $mod;
							}
						}
						if( !empty($vw_corporate_lite_service_page) ) :
						  $args = array(
						    'post_type' => 'page',
						    'post__in' => $vw_corporate_lite_service_page,
						    'orderby' => 'post__in'
						  );
						  $query = new WP_Query( $args );
						  if ( $query->have_posts() ) :
						    $count = 0;
								while ( $query->have_posts() ) : $query->the_post(); ?>
									<div class="col-lg-4 col-md-6 services-box">
										<div class="row">
											<div class="col-lg-6 col-md-6 textimage">
											    <div class="box-content text-center">
											    	<h3><?php the_title(); ?></h3>
											    	<p><?php $vw_corporate_lite_excerpt = get_the_excerpt(); echo esc_html( vw_corporate_lite_string_limit_words( $vw_corporate_lite_excerpt, esc_attr(get_theme_mod('vw_corporate_lite_services_excerpt_number','30')))); ?></p>
											        <div class="clearfix"></div>
											        <?php if( get_theme_mod('vw_corporate_lite_services_button_text','Read More') != ''){ ?>
											        	<a class="r_button hvr-sweep-to-right"  href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_theme_mod('vw_corporate_lite_services_button_text',__('Read More','vw-corporate-lite')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_corporate_lite_services_button_text',__('Read More','vw-corporate-lite')));?></span></a>
											        <?php } ?>
											    </div>
											</div>
											<div class="col-md-6 col-sm-6">
											    <div class="box-image">
											        <?php the_post_thumbnail(); ?>
											    </div>
										    </div>	
									    </div>
									</div>
								<?php $count++; endwhile; ?>
						  <?php else : ?>
						      <div class="no-postfound"></div>
						  <?php endif;
						endif;?>
					    <div class="clearfix"></div>
					</div>
				</div>
			</div> 
		</section>
	<?php }?>

	<?php do_action( 'vw_corporate_lite_above_content' ); ?>

	<div class="container">
	  <?php while ( have_posts() ) : the_post(); ?>
	        <?php the_content(); ?>
	    <?php endwhile; // end of the loop. ?>
	</div>	
</main>

<?php get_footer(); ?>