<?php
/**
 * VW Corporate Lite: Block Patterns
 *
 * @package VW Corporate Lite
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'vw-corporate-lite',
		array( 'label' => __( 'VW Corporate Lite', 'vw-corporate-lite' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-corporate-lite/banner-section',
		array(
			'title'      => __( 'Banner Section', 'vw-corporate-lite' ),
			'categories' => array( 'vw-corporate-lite' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider.png\",\"id\":3131,\"dimRatio\":30,\"overlayColor\":\"black\",\"align\":\"full\",\"className\":\"sliderbox\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim-30 has-black-background-color has-background-dim sliderbox\"><img class=\"wp-block-cover__image-background wp-image-3131\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"className\":\"mx-md-5 mx-0 px-lg-5\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center mx-md-5 mx-0 px-lg-5\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"70%\",\"className\":\"ps-lg-4\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center ps-lg-4\" style=\"flex-basis:70%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":1,\"style\":{\"typography\":{\"fontSize\":40}},\"textColor\":\"white\"} -->\n<h1 class=\"has-text-align-left has-white-color has-text-color\" style=\"font-size:40px\"><strong>LOREM IPSUM IS SIMPLY DUMMY TEXT</strong></h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":15}},\"textColor\":\"white\"} -->\n<p class=\"has-text-align-left has-white-color has-text-color\" style=\"font-size:15px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":25,\"textColor\":\"white\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-color has-text-color\" style=\"border-radius:25px\"><strong>READ MORE</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-corporate-lite/services-section',
		array(
			'title'      => __( 'Services Section', 'vw-corporate-lite' ),
			'categories' => array( 'vw-corporate-lite' ),
			'content'    => "<!-- wp:group {\"align\":\"wide\",\"className\":\"servicebox mt-5 mx-0\"} -->\n<div class=\"wp-block-group alignwide servicebox mt-5 mx-0\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#002857\"},\"typography\":{\"fontSize\":30}},\"className\":\"mb-2\"} -->\n<h2 class=\"has-text-align-center mb-2 has-text-color\" style=\"color:#002857;font-size:30px\">OUR SERVICES</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#002857\"},\"typography\":{\"fontSize\":12}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#002857;font-size:12px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:columns {\"align\":\"wide\",\"className\":\"service-col mx-2 mt-5 mt-md-3\"} -->\n<div class=\"wp-block-columns alignwide service-col mx-2 mt-5 mt-md-3\"><!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"service-content mb-3\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center service-content mb-3\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#002857\"}},\"className\":\"mb-2\"} -->\n<h3 class=\"has-text-align-center mb-2 has-text-color\" style=\"color:#002857;font-size:18px\">Service Title 1</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#002857\"}},\"className\":\"service-content-para\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center service-content-para has-text-color has-small-font-size\" style=\"color:#002857\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"contentJustification\":\"center\"} -->\n<div class=\"wp-block-buttons is-content-justification-center\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"text\":\"#002857\"}},\"className\":\"hvr-sweep-to-right\"} -->\n<div class=\"wp-block-button hvr-sweep-to-right\"><a class=\"wp-block-button__link has-text-color no-border-radius\" style=\"color:#002857\"><strong>Read More</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"service-img mb-md-0 mb-5\"} -->\n<div class=\"wp-block-column service-img mb-md-0 mb-5\"><!-- wp:image {\"align\":\"center\",\"id\":3060,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/service1.png\" alt=\"\" class=\"wp-image-3060\"/></figure></div>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"service-content mb-3\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center service-content mb-3\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#002857\"}},\"className\":\"mb-2\"} -->\n<h3 class=\"has-text-align-center mb-2 has-text-color\" style=\"color:#002857;font-size:18px\">Service Title 2</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#002857\"}},\"className\":\"service-content-para\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center service-content-para has-text-color has-small-font-size\" style=\"color:#002857\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"contentJustification\":\"center\"} -->\n<div class=\"wp-block-buttons is-content-justification-center\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"text\":\"#002857\"}},\"className\":\"hvr-sweep-to-right\"} -->\n<div class=\"wp-block-button hvr-sweep-to-right\"><a class=\"wp-block-button__link has-text-color no-border-radius\" style=\"color:#002857\"><strong>Read More</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"service-img mb-md-0 mb-5\"} -->\n<div class=\"wp-block-column service-img mb-md-0 mb-5\"><!-- wp:image {\"align\":\"center\",\"id\":3061,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/service2.png\" alt=\"\" class=\"wp-image-3061\"/></figure></div>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"service-content mb-3\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center service-content mb-3\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#002857\"}},\"className\":\"mb-2\"} -->\n<h3 class=\"has-text-align-center mb-2 has-text-color\" style=\"color:#002857;font-size:18px\">Service Title 3</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#002857\"}},\"className\":\"service-content-para\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center service-content-para has-text-color has-small-font-size\" style=\"color:#002857\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"contentJustification\":\"center\"} -->\n<div class=\"wp-block-buttons is-content-justification-center\"><!-- wp:button {\"borderRadius\":0,\"style\":{\"color\":{\"text\":\"#002857\"}},\"className\":\"hvr-sweep-to-right\"} -->\n<div class=\"wp-block-button hvr-sweep-to-right\"><a class=\"wp-block-button__link has-text-color no-border-radius\" style=\"color:#002857\"><strong>Read More</strong></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"service-img mb-md-0 mb-5\"} -->\n<div class=\"wp-block-column service-img mb-md-0 mb-5\"><!-- wp:image {\"align\":\"center\",\"id\":3063,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/service3.png\" alt=\"\" class=\"wp-image-3063\"/></figure></div>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
		)
	);
}