<?php
/**
 * Wizard
 *
 * @package Whizzie
 * @author Catapult Themes
 * @since 1.0.0
 */


class ThemeWhizzie {

	public static $is_valid_key = 'false';
	public static $theme_key 		= '';

	protected $version = '1.1.0';

	/** @var string Current theme name, used as namespace in actions. */
	protected $theme_name = '';
	protected $theme_title = '';

	/** @var string Wizard page slug and title. */
	protected $page_slug = '';
	protected $page_title = '';

	/** @var array Wizard steps set by user. */
	protected $config_steps = array();

	/**
	 * Relative plugin url for this plugin folder
	 * @since 1.0.0
	 * @var string
	 */
	protected $plugin_url = '';

	/**
	 * TGMPA instance storage
	 *
	 * @var object
	 */
	protected $tgmpa_instance;

	/**
	 * TGMPA Menu slug
	 *
	 * @var string
	 */
	protected $tgmpa_menu_slug = 'tgmpa-install-plugins';

	/**
	 * TGMPA Menu url
	 *
	 * @var string
	 */
	protected $tgmpa_url = 'themes.php?page=tgmpa-install-plugins';

	// Where to find the widget.wie file
	protected $widget_file_url = '';

	/**
	 * Constructor
	 *
	 * @param $vw_black_and_white_pro_config	Our config parameters
	 */
	public function __construct( $vw_black_and_white_pro_config ) {
		$this->set_vars( $vw_black_and_white_pro_config );
		$this->init();

		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	}

	public static function get_the_validation_status() {
		return get_option('vw_black_and_white_pro_theme_validation_status');
	}

	public static function set_the_validation_status($is_valid) {
		update_option('vw_black_and_white_pro_theme_validation_status', $is_valid);
	}

	public static function get_the_suspension_status() {
		return get_option( 'vw_black_and_white_pro_theme_suspension_status' );
	}

	public static function set_the_suspension_status( $is_suspended ) {
		update_option( 'vw_black_and_white_pro_theme_suspension_status' , $is_suspended );
	}
	
	public static function set_the_theme_key($the_key) {
		update_option('vw_pro_theme_key', $the_key);
	}

	public static function remove_the_theme_key() {
		delete_option('vw_pro_theme_key');
	}

	public static function get_the_theme_key() {
		return get_option('vw_pro_theme_key');
	}

	/**
	 * Set some settings
	 * @since 1.0.0
	 * @param $vw_black_and_white_pro_config	Our config parameters
	 */
	public function set_vars( $vw_black_and_white_pro_config ) {

		require_once trailingslashit( WHIZZIE_DIR ) . 'tgm/tgm.php';
		require_once trailingslashit( WHIZZIE_DIR ) . 'widgets/class-vw-widget-importer.php';

		if( isset( $vw_black_and_white_pro_config['page_slug'] ) ) {
			$this->page_slug = esc_attr( $vw_black_and_white_pro_config['page_slug'] );
		}
		if( isset( $vw_black_and_white_pro_config['page_title'] ) ) {
			$this->page_title = esc_attr( $vw_black_and_white_pro_config['page_title'] );
		}
		if( isset( $vw_black_and_white_pro_config['steps'] ) ) {
			$this->config_steps = $vw_black_and_white_pro_config['steps'];
		}

		$this->plugin_path = trailingslashit( dirname( __FILE__ ) );
		$relative_url = str_replace( get_template_directory(), '', $this->plugin_path );
		$this->plugin_url = trailingslashit( get_template_directory_uri() . $relative_url );
		$current_theme = wp_get_theme();
		$this->theme_title = $current_theme->get( 'Name' );
		$this->theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $current_theme->get( 'Name' ) ) );
		$this->page_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_page_slug', $this->theme_name . '-wizard' );
		$this->parent_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_parent_slug', '' );

		$this->widget_file_url = trailingslashit( WHIZZIE_DIR ) . 'widgets/vw-black-and-white-pro-widgets.wie';

	}

	/**
	 * Hooks and filters
	 * @since 1.0.0
	 */
	public function init() {

		if ( class_exists( 'TGM_Plugin_Activation' ) && isset( $GLOBALS['tgmpa'] ) ) {
			add_action( 'init', array( $this, 'get_tgmpa_instance' ), 30 );
			add_action( 'init', array( $this, 'set_tgmpa_url' ), 40 );
		}

		add_action( 'after_switch_theme', array( $this, 'redirect_to_wizard' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'admin_init', array( $this, 'get_plugins' ), 30 );
		add_filter( 'tgmpa_load', array( $this, 'tgmpa_load' ), 10, 1 );
		add_action( 'wp_ajax_setup_plugins', array( $this, 'setup_plugins' ) );
		add_action( 'wp_ajax_setup_widgets', array( $this, 'setup_widgets' ) );

		add_action( 'wp_ajax_setup_builder', array( $this, 'setup_builder' ) );
		add_action( 'wp_ajax_wz_install_activate_ibtana', array( $this, 'wz_install_activate_ibtana' ) );

		add_action( 'wp_ajax_wz_activate_vw_black_and_white_pro', array( $this, 'wz_activate_vw_black_and_white_pro' ) );

		add_action('admin_enqueue_scripts',  array( $this, 'vw_black_and_white_pro_admin_theme_style' ) );
	

	}

	public function redirect_to_wizard() {
		global $pagenow;
		if( is_admin() && 'themes.php' == $pagenow && isset( $_GET['activated'] ) && current_user_can( 'manage_options' ) ) {
			wp_redirect( admin_url( 'themes.php?page=' . esc_attr( $this->page_slug ) ) );
		}
	}

	public function enqueue_scripts() {
		wp_enqueue_style( 'theme-wizard-style', get_template_directory_uri() . '/theme-wizard/assets/css/theme-wizard-style.css');
		wp_register_script( 'theme-wizard-script', get_template_directory_uri() . '/theme-wizard/assets/js/theme-wizard-script.js', array( 'jquery' ), time() );
		wp_localize_script(
			'theme-wizard-script',
			'vw_black_and_white_pro_whizzie_params',
			array(
				'ajaxurl' 		=> admin_url( 'admin-ajax.php' ),
				'wpnonce' 		=> wp_create_nonce( 'whizzie_nonce' ),
				'verify_text'	=> esc_html( 'verifying', 'vw-black-and-white-pro' ),
				'IBTANA_THEME_LICENCE_ENDPOINT' => IBTANA_THEME_LICENCE_ENDPOINT
			)
		);
		wp_enqueue_script( 'theme-wizard-script' );
		wp_enqueue_script('tabs', get_template_directory_uri() . '/theme-wizard/getstarted/js/tab.js');
		wp_enqueue_script( 'vw-notify-popup', get_template_directory_uri() . '/assets/js/notify.min.js');
	}

	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	public function tgmpa_load( $status ) {
		return is_admin() || current_user_can( 'install_themes' );
	}

	/**
	 * Get configured TGMPA instance
	 *
	 * @access public
	 * @since 1.1.2
	 */
	public function get_tgmpa_instance() {
		$this->tgmpa_instance = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
	}

	/**
	 * Update $tgmpa_menu_slug and $tgmpa_parent_slug from TGMPA instance
	 *
	 * @access public
	 * @since 1.1.2
	 */
	public function set_tgmpa_url() {
		$this->tgmpa_menu_slug = ( property_exists( $this->tgmpa_instance, 'menu' ) ) ? $this->tgmpa_instance->menu : $this->tgmpa_menu_slug;
		$this->tgmpa_menu_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_tgmpa_menu_slug', $this->tgmpa_menu_slug );
		$tgmpa_parent_slug = ( property_exists( $this->tgmpa_instance, 'parent_slug' ) && $this->tgmpa_instance->parent_slug !== 'themes.php' ) ? 'admin.php' : 'themes.php';
		$this->tgmpa_url = apply_filters( $this->theme_name . '_theme_setup_wizard_tgmpa_url', $tgmpa_parent_slug . '?page=' . $this->tgmpa_menu_slug );
	}

	/**
	 * Make a modal screen for the wizard
	 */
	public function menu_page() {
		add_menu_page( esc_html( $this->page_title ), esc_html( $this->page_title ), 'manage_options', $this->page_slug, array( $this, 'vw_black_and_white_pro_mostrar_guide' ) ,get_template_directory_uri().'/theme-wizard/assets/images/admin-menu.svg',40);
	}

	public function activation_page() {
		$theme_key 						= ThemeWhizzie::get_the_theme_key();
		$validation_status 		= ThemeWhizzie::get_the_validation_status();
		?>
		<div class="wrap">
			<label><?php esc_html_e('Enter Your Theme License Key:','vw-black-and-white-pro'); ?></label>
			<form id="vw_black_and_white_pro_license_form">
				<input type="text" name="vw_black_and_white_pro_license_key" value="<?php echo $theme_key ?>" <?php if($validation_status === 'true') { echo "disabled"; } ?> required placeholder="License Key" />
				<div class="licence-key-button-wrap">
					<button class="button" type="submit" name="button" <?php if($validation_status === 'true') { echo "disabled"; } ?>>
						<?php if ($validation_status === 'true') {
						?>
							Activated
						<?php
						} else { ?>
							Activate
						<?php
						}
						?>
					</button>

					<?php if ($validation_status === 'true') { ?>
						<button id="change--key" class="button" type="button" name="button">
							Change Key
						</button>
						<div class="next-button">
						<button id="start-now-next" class="button" type="button" name="button" onclick="openCity(event, 'demo_offer')">
							Next
						</button>
					</div>
					<?php } ?>
				</div>
			</form>
		</div>
		<?php
	}

	/**
	 * Make an interface for the wizard
	 */
	public function wizard_page() {

		tgmpa_load_bulk_installer();

		// install plugins with TGM.
		if ( ! class_exists( 'TGM_Plugin_Activation' ) || ! isset( $GLOBALS['tgmpa'] ) ) {
			die( 'Failed to find TGM' );
		}
		$url = wp_nonce_url( add_query_arg( array( 'plugins' => 'go' ) ), 'whizzie-setup' );

		// copied from TGM
		$method = ''; // Leave blank so WP_Filesystem can populate it as necessary.
		$fields = array_keys( $_POST ); // Extra fields to pass to WP_Filesystem.
		if ( false === ( $creds = request_filesystem_credentials( esc_url_raw( $url ), $method, false, false, $fields ) ) ) {
			return true; // Stop the normal page form from displaying, credential request form will be shown.
		}
		// Now we have some credentials, setup WP_Filesystem.
		if ( ! WP_Filesystem( $creds ) ) {
			// Our credentials were no good, ask the user for them again.
			request_filesystem_credentials( esc_url_raw( $url ), $method, true, false, $fields );
			return true;
		}


		/* If we arrive here, we have the filesystem */ ?>
		<div class="wrap">
			<div class="wizard-logo-wrap">
				<img src="<?php echo esc_url(get_template_directory_uri().'/theme-wizard/assets/images/adminIcon.png'); ?>">
				<span class="wizard-main-title">
					<?php esc_html_e('Welcome to ','vw-black-and-white-pro'); echo $this->theme_title; ?>
				</span>
			</div>
			<?php echo '<div class="card whizzie-wrap">';
				// The wizard is a list with only one item visible at a time
				$steps = $this->get_steps();
				echo '<ul class="whizzie-menu vw-wizard-menu-page">';
				foreach( $steps as $step ) {
					$class = 'step step-' . esc_attr( $step['id'] );
					echo '<li data-step="' . esc_attr( $step['id'] ) . '" class="' . esc_attr( $class ) . '" >';
						printf( '<span class="wizard-main-title">%s</span>',
							esc_html( $step['title'] )
							);
						// $content is split into summary and detail
						$content = call_user_func( array( $this, $step['view'] ) );
						if( isset( $content['summary'] ) ) {
							printf(
								'<div class="summary">%s</div>',
								wp_kses_post( $content['summary'] )
							);
						}
						if( isset( $content['detail'] ) ) {
							// Add a link to see more detail
							printf( '<div class="wz-require-plugins">');
							printf(
								'<div class="detail">%s</div>',
								$content['detail'] // Need to escape this
							);
							printf('</div>');
						}

						printf('<div class="wizard-button-wrapper">');
						  if (ThemeWhizzie::get_the_validation_status() === 'true') {
							// The next button
							if( isset( $step['button_text'] ) && $step['button_text'] ) {
								printf(
									'<div class="button-wrap"><a href="#" class="button button-primary do-it" data-callback="%s" data-step="%s">%s</a></div>',
									esc_attr( $step['callback'] ),
									esc_attr( $step['id'] ),
									esc_html( $step['button_text'] )
								);
							}

							if( isset( $step['button_text_one'] )) {
								printf(
									'<div class="button-wrap button-wrap-one">
										<a href="#" class="button button-primary do-it" data-callback="install_widgets" data-step="widgets"><img src="'.get_template_directory_uri().'/theme-wizard/assets/images/Customize-Icon.png"></a>
										<p class="demo-type-text">%s</p>
									</div>',
									esc_html( $step['button_text_one'] )
								);
							}
							if( isset( $step['button_text_two'] )) {
								printf(
									'<div class="button-wrap button-wrap-two">
										<a href="#" class="button button-primary do-it" data-step="widgets" data-callback="page_builder" id="ibtana_button"><img src="'.get_template_directory_uri().'/theme-wizard/assets/images/Gutenberg-Icon.png"></a>
										<p class="demo-type-text">%s</p>
									</div>',
									esc_html( $step['button_text_two'] )
								);
							}
							
						} else {
							printf(
								'<div class="button-wrap"><a href="#" class="button button-primary key-activation-tab-click">%s</a></div>',
								esc_html( __( 'Activate Your License', 'vw-black-and-white-pro' ) )
							);
						}
						printf('</div>');

					echo '</li>';
				}
				echo '</ul>';
				echo '<ul class="whizzie-nav wizard-icon-nav">';
					$stepI=1;
					foreach( $steps as $step ) {
						$stepAct=($stepI ==1)? 1 : 0;
						if( isset( $step['icon_url'] ) && $step['icon_url'] ) {
							echo '<li class="nav-step-' . esc_attr( $step['id'] ) . '" wizard-steps="step-'.esc_attr( $step['id'] ).'" data-enable="'.$stepAct.'">
							<img src="'.esc_attr( $step['icon_url'] ).'">
							</li>';
						}
					$stepI++;}
				echo '</ul>';
				?>
				<div class="step-loading"><span class="spinner">
					<img src="<?php echo esc_url(get_template_directory_uri().'/theme-wizard/assets/images/Spinner-Animaion.gif'); ?>">
				</span></div>
			<?php echo '</div>';?>

		</div>
	<?php }
	/**
	 * Set options for the steps
	 * Incorporate any options set by the theme dev
	 * Return the array for the steps
	 * @return Array
	 */
	public function get_steps() {
		$dev_steps = $this->config_steps;
		$steps = array(
			'intro' => array(
				'id'			=> 'intro',
				'title'			=> __( '', 'vw-black-and-white-pro' ),
				'icon'			=> 'dashboard',
				'view'			=> 'get_step_intro', // Callback for content
				'callback'		=> 'do_next_step', // Callback for JS
				'button_text'	=> __( 'Start Now', 'vw-black-and-white-pro' ),
				'can_skip'		=> false, // Show a skip button?
				'icon_url'      => get_template_directory_uri().'/theme-wizard/assets/images/Icons-01.svg'
			),
			'plugins' => array(
				'id'			=> 'plugins',
				'title'			=> __( 'Plugins', 'vw-black-and-white-pro' ),
				'icon'			=> 'admin-plugins',
				'view'			=> 'get_step_plugins',
				'callback'		=> 'install_plugins',
				'button_text'	=> __( 'Install Plugins', 'vw-black-and-white-pro' ),
				'can_skip'		=> true,
				'icon_url'      => get_template_directory_uri().'/theme-wizard/assets/images/Icons-02.svg'
			),
			'widgets' => array(
				'id'			=> 'widgets',
				'title'			=> __( 'Customizer', 'vw-black-and-white-pro' ),
				'icon'			=> 'welcome-widgets-menus',
				'view'			=> 'get_step_widgets',
				'callback'		=> 'install_widgets',
				'button_text_one'	=> __( 'Click On The Image To Import Customizer Demo', 'vw-black-and-white-pro' ),
				'button_text_two'	=> __( 'Click On The Image To Import Gutenberg Block Demo', 'vw-black-and-white-pro' ),
				'can_skip'		=> true,
				'icon_url'      => get_template_directory_uri().'/theme-wizard/assets/images/Icons-03.svg'
			),
			
			'done' => array(
				'id'			=> 'done',
				'title'			=> __( 'All Done', 'vw-black-and-white-pro' ),
				'icon'			=> 'yes',
				'view'			=> 'get_step_done',
				'callback'		=> '',
				'icon_url'      => get_template_directory_uri().'/theme-wizard/assets/images/Icons-04.svg'
			)
		);

		// Iterate through each step and replace with dev config values
		if( $dev_steps ) {
			// Configurable elements - these are the only ones the dev can update from config.php
			$can_config = array( 'title', 'icon', 'button_text', 'can_skip','button_text_two' );
			foreach( $dev_steps as $dev_step ) {
				// We can only proceed if an ID exists and matches one of our IDs
				if( isset( $dev_step['id'] ) ) {
					$id = $dev_step['id'];
					if( isset( $steps[$id] ) ) {
						foreach( $can_config as $element ) {
							if( isset( $dev_step[$element] ) ) {
								$steps[$id][$element] = $dev_step[$element];
							}
						}
					}
				}
			}
		}
		return $steps;
	}

	/**
	 * Print the content for the intro step
	 */
	public function get_step_intro() { ?>
		<div class="summary">
			<p>
				<?php esc_html_e('Thank you for choosing this','vw-black-and-white-pro').$this->theme_title.esc_html_e(' Theme. Using this quick setup wizard, you will be able to configure your new website and get it running in just a few minutes. Just follow these simple steps mentioned in the wizard and get started with your website.','vw-black-and-white-pro'); ?>
			</p>
			<p>
				<?php esc_html_e('You may even skip the steps and get back to the dashboard if you have no time at the present moment. You can come back any time if you change your mind.','vw-black-and-white-pro'); ?>
			</p>
		</div>
	<?php }

	public function get_step_importer() { ?>
		<div class="summary">
			<p>
				<?php esc_html_e('Thank you for choosing this ','vw-black-and-white-pro').$this->theme_title.esc_html_e(' Theme. Using this quick setup wizard, you will be able to configure your new website and get it running in just a few minutes. Just follow these simple steps mentioned in the wizard and get started with your website.','vw-black-and-white-pro'); ?>
			</p>
		</div>
	<?php }
	/**
	 * Get the content for the plugins step
	 * @return $content Array
	 */
	public function get_step_plugins() {
		$plugins = $this->get_plugins();
		$content = array(); ?>
			<div class="summary">
				<p>
					<?php esc_html_e('Additional plugins always make your website exceptional. Install these plugins by clicking the install button. You may also deactivate them from the dashboard.','vw-black-and-white-pro') ?>
				</p>
			</div>
		<?php // The detail element is initially hidden from the user
		$content['detail'] = '<span class="wizard-plugin-count">'.count($plugins['all']).'</span><ul class="whizzie-do-plugins">';
		// Add each plugin into a list
		foreach( $plugins['all'] as $slug=>$plugin ) {
			$content['detail'] .= '<li data-slug="' . esc_attr( $slug ) . '">' . esc_html( $plugin['name'] ) . '<div class="wizard-plugin-title">';

			$content['detail'] .= '<span class="wizard-plugin-status">Installation Required</span><i class="spinner"></i></div></li>';
			
		}
		$content['detail'] .= '</ul>';

		return $content;
	}

	
	/**
	 * Print the content for the widgets step
	 * @since 1.1.0
	 */
	public function get_step_widgets() { ?>
		<div class="summary">
			<p>
				<?php esc_html_e('This theme supports importing the demo content and adding widgets. Get them installed with the below button. Using the Customizer, it is possible to update or even deactivate them','vw-black-and-white-pro'); ?>
			</p>
		</div>
	<?php }


	/**
	 * Print the content for the Design choices for the user
	 */

	public function get_step_design() { ?>

		<div class="ibtana-design-product-row">
		</div> 
		<div class="wizard-design-button-wrapper">
			<a href="#" class="button button-primary do-it" data-step="design" id="IbtanaImportButton" data-callback="inner_page_builder">Import</a>
		</div>

	<?php }
	/**
	 * Print the content for the final step
	 */
	public function get_step_done() {

	 ?>

		<div class="vw-setup-finish">
			<p>
				<?php echo esc_html('Your demo content has been imported successfully . Click on the finish button for more information.'); ?>
			</p>
			<div class="finish-buttons">
				<a href="<?php echo esc_url(admin_url('/customize.php')); ?>" class="wz-btn-customizer" target="_blank"><?php esc_html_e('Customize Your Demo','vw-black-and-white-pro') ?></a>
				<a href="" class="wz-btn-builder" target="_blank"><?php esc_html_e('Customize Your Demo','vw-black-and-white-pro'); ?></a>
				<a href="<?php echo esc_url(site_url()); ?>" class="wz-btn-visit-site" target="_blank"><?php esc_html_e('Visit Your Site','vw-black-and-white-pro'); ?></a>
			</div>
			<div class="vw-finish-btn">
				<a href="javascript:void(0);" class="button button-primary" onclick="openCity(event, 'theme_info')" data-tab="theme_info">Finish</a>
			</div>
		</div>

	<?php }

	/**
	 * Get the plugins registered with TGMPA
	 */
	public function get_plugins() {

		$instance = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );
		$plugins = array(
			'all' 		=> array(),
			'install'	=> array(),
			'update'	=> array(),
			'activate'	=> array()
		);
		foreach( $instance->plugins as $slug=>$plugin ) {
			if( $instance->is_plugin_active( $slug ) && false === $instance->does_plugin_have_update( $slug ) ) {
				// Plugin is installed and up to date
				continue;
			} else {
				$plugins['all'][$slug] = $plugin;
				if( ! $instance->is_plugin_installed( $slug ) ) {
					$plugins['install'][$slug] = $plugin;
				} else {
					if( false !== $instance->does_plugin_have_update( $slug ) ) {
						$plugins['update'][$slug] = $plugin;
					}
					if( $instance->can_plugin_activate( $slug ) ) {
						$plugins['activate'][$slug] = $plugin;
					}
				}
			}
		}
		return $plugins;
	}

	public function setup_plugins() {

		if ( ! check_ajax_referer( 'whizzie_nonce', 'wpnonce' ) || empty( $_POST['slug'] ) ) {
			wp_send_json_error( array( 'error' => 1, 'message' => esc_html__( 'No Slug Found','vw-black-and-white-pro' ) ) );
		}
		$json = array();
		// send back some json we use to hit up TGM
		$plugins = $this->get_plugins();

		// what are we doing with this plugin?
		foreach ( $plugins['activate'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-activate',
					'action2'       => - 1,
					'message'       => esc_html__( 'Activating Plugin','vw-black-and-white-pro' ),
				);
				break;
			}
		}
		foreach ( $plugins['update'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-update',
					'action2'       => - 1,
					'message'       => esc_html__( 'Updating Plugin','vw-black-and-white-pro' ),
				);
				break;
			}
		}
		foreach ( $plugins['install'] as $slug => $plugin ) {
			if ( $_POST['slug'] == $slug ) {
				$json = array(
					'url'           => admin_url( $this->tgmpa_url ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => $this->tgmpa_menu_slug,
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-install',
					'action2'       => - 1,
					'message'       => esc_html__( 'Installing Plugin','vw-black-and-white-pro' ),
				);
				break;
			}
		}
		if ( $json ) {
			$json['hash'] = md5( serialize( $json ) ); // used for checking if duplicates happen, move to next plugin
			wp_send_json( $json );
		} else {
			wp_send_json( array( 'done' => 1, 'message' => esc_html__( 'Success','vw-black-and-white-pro' ) ) );
		}
		exit;
	}
public function theme_create_customizer_nav_menu()
		{

		 // ------- Create Nav Menu --------
        $menuname = $lblg_themename . 'Primary Menu';
		$bpmenulocation = 'primary';
		$menu_exists = wp_get_nav_menu_object( $menuname );

		if( !$menu_exists){
		    $menu_id = wp_create_nav_menu($menuname);
		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Home','vw-black-and-white-pro'),
		        'menu-item-classes' => 'home',
		        'menu-item-url' => home_url( '/' ), 
		        'menu-item-status' => 'publish'));

		    $parent_item =  wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Blog','vw-black-and-white-pro'),
		        'menu-item-classes' => 'blog',
		        'menu-item-url' => ('#'),    
		        'menu-item-status' => 'publish'));

		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Blog with No Sidebar','vw-black-and-white-pro'),
		        'menu-item-classes' => 'blog',
		        'menu-item-url' => get_permalink(get_page_by_title('Blog')), 
		        'menu-item-status' => 'publish',
		        'menu-item-parent-id' => $parent_item
		    ));

		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Blog with Left Sidebar','vw-black-and-white-pro'),
		        'menu-item-classes' => 'blog-with-left-sidebar',
		        'menu-item-url' => get_permalink(get_page_by_title('Blog with Left Sidebar')), 
		        'menu-item-status' => 'publish',
		        'menu-item-parent-id' => $parent_item
		    ));

		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Blog with Right Sidebar','vw-black-and-white-pro'),
		        'menu-item-classes' => 'blog-with-right-sidebar',
		        'menu-item-url' => get_permalink(get_page_by_title('Blog with Right Sidebar')),
		        'menu-item-status' => 'publish',
		        'menu-item-parent-id' => $parent_item
		    ));

		     $pageparent_item  = wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Page','vw-black-and-white-pro'),
		        'menu-item-classes' => 'page',
		        'menu-item-url' => ('#'), 
		        'menu-item-status' => 'publish'));

		       wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Page with No Sidebar','vw-black-and-white-pro'),
		        'menu-item-classes' => 'page',
		        'menu-item-url' => get_permalink(get_page_by_title('Page')), 
		        'menu-item-status' => 'publish',
		        'menu-item-parent-id' => $pageparent_item
		    	));

		      wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Page with Left Sidebar','vw-black-and-white-pro'),
		        'menu-item-classes' => 'page-with-left-sidebar',
		        'menu-item-url' => get_permalink(get_page_by_title('Page with Left Sidebar')),
		        'menu-item-status' => 'publish',
		        'menu-item-parent-id' => $pageparent_item
		    ));

		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Page with Right Sidebar','vw-black-and-white-pro'),
		        'menu-item-classes' => 'page-with-right-sidebar',
		        'menu-item-url' => get_permalink(get_page_by_title('Page with Right Sidebar')),
		        'menu-item-status' => 'publish',
		        'menu-item-parent-id' => $pageparent_item
		    ));
		     wp_update_nav_menu_item($menu_id, 0, array(
				'menu-item-title' =>  __('Typography','tg-grocery-pro'),
				'menu-item-classes' => 'typography',
				'menu-item-url' => get_permalink(get_page_by_title('Typography')),
				'menu-item-status' => 'publish',
				'menu-item-parent-id' => $pageparent_item
			));
		     wp_update_nav_menu_item($menu_id, 0, array(
				'menu-item-title' =>  __('Error 404','tg-grocery-pro'),
				'menu-item-classes' => 'error-404',
				'menu-item-url' => get_permalink(get_page_by_title('Error 404')),
				'menu-item-status' => 'publish',
				'menu-item-parent-id' => $pageparent_item
			));
		     wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('FAQ','vw-black-and-white-pro'),
		        'menu-item-classes' => 'faq',
		        'menu-item-url' => get_permalink(get_page_by_title('FAQ')),
		        'menu-item-status' => 'publish',
		        'menu-item-parent-id' => $pageparent_item
		    ));


		   wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Contact','vw-black-and-white-pro'),
		        'menu-item-classes' => 'contact',
		        'menu-item-url' => get_permalink(get_page_by_title('Contact')),
		        'menu-item-status' => 'publish'));

		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('About Us','vw-black-and-white-pro'),
		        'menu-item-classes' => 'about-us',
		        'menu-item-url' => get_permalink(get_page_by_title('About Us')),
		        'menu-item-status' => 'publish'));

             if( !has_nav_menu( $bpmenulocation ) ){
		        $locations = get_theme_mod('nav_menu_locations');
		        $locations[$bpmenulocation] = $menu_id;
		        set_theme_mod( 'nav_menu_locations', $locations );
		    }
		}
}

public function theme_create_customizer_footer_menu()
{
		 // ------- Create Nav Menu --------
        $menuname = $lblg_themename . 'Footer Menu';
		$bpmenulocation = 'footer';
		$menu_exists = wp_get_nav_menu_object( $menuname );

		if( !$menu_exists){
		    $menu_id = wp_create_nav_menu($menuname);
		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('About','vw-black-and-white-pro'),
		        'menu-item-url' => get_permalink(get_page_by_title('About Us')),
		        'menu-item-status' => 'publish'));

		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Portfolio','vw-black-and-white-pro'),
		         'menu-item-url' => ('#'),
		        'menu-item-status' => 'publish'));

		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Contact Us','vw-black-and-white-pro'),
		        'menu-item-url' => get_permalink(get_page_by_title('Contact Us')),
		        'menu-item-status' => 'publish'));

		    wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('FAQ','vw-black-and-white-pro'),
		        'menu-item-url' => get_permalink(get_page_by_title('FAQ')),
		        'menu-item-status' => 'publish'));

		     wp_update_nav_menu_item($menu_id, 0, array(
		        'menu-item-title' =>  __('Blog','vw-black-and-white-pro'),
		        'menu-item-url' => get_permalink(get_page_by_title('Blog')),
		        'menu-item-status' => 'publish'));

                if( !has_nav_menu( $bpmenulocation ) ){
		        $locations = get_theme_mod('nav_menu_locations');
		        $locations[$bpmenulocation] = $menu_id;
		        set_theme_mod( 'nav_menu_locations', $locations );
		    }
		}
}

      public function custom_posttype_option(){
	  $getOption = get_option('icpa_settings');

	  $support_arr =array(
	    'title' => 'on',
	    'editor' => 'on',
	    'thumbnail' => 'on',
	    'custom-fields' => 'on',
	    'page-attributes' => 'on',
	    'comments' => 'on',
	    'author' => 'on'
	  );

	  $posttype_arr = array(
	
	    array(
	      'posttype_name' => 'services',
	      'plural_label' => 'Services',
	      'singular_label' => 'Services',
	      'support' => $support_arr,
	      'is_display' => 1,
	    ),
	    array(
	      'posttype_name' => 'portfolio',
	      'plural_label' => 'portfolio',
	      'singular_label' => 'portfolio',
	      'support' => $support_arr,
	      'is_display' => 1,
	    ),
	    array(
	      'posttype_name' => 'our-client',
	      'plural_label' => 'our-client',
	      'singular_label' => 'our-client',
	      'support' => $support_arr,
	      'is_display' => 1,
	    ),
	    array(
	      'posttype_name' => 'team',
	      'plural_label' => 'Team',
	      'singular_label' => 'Team',
	      'support' => $support_arr,
	      'is_display' => 1,
	    ),
	    // array(
	    //   'posttype_name' => 'testimonial',
	    //   'plural_label' => 'Testimonial',
	    //   'singular_label' => 'Testimonial',
	    //   'support' => $support_arr,
	    //   'is_display' => 1,
	    // )
	  );

	  foreach ($posttype_arr as $posttype) {
	    if ($getOption) {
	      array_push($getOption, $posttype);
	    }else{
	      $getOption = [];
	      array_push($getOption, $posttype);
	    }
	  }

	  return update_option('icpa_settings', $getOption);
	}
	public function custom_taxonomy_option(){
		$getOption = get_option('icpa_tax_settings');

		$posttype_arr = array(
		array(
				'taxonomy_name'					=> 'projectscategory',
				'tax_plural_label'			=> 'Categories',
		    'tax_singular_label'		=> 'Categories',
				'posttype'							=> array(
					'projects' => 'on'
				),
				'tax_attach_thumbnail'	=> true,
		    'tax_search_item'				=> 'Search Categories',
		    'tax_all_items'         => 'All Categories',
		    'tax_parent_item'       => 'Parent Category',
		    'tax_parent_item_colon' => 'Parent Category:',
		    'tax_edit_item'         => 'Edit Category',
		    'tax_update_item'       => 'Update Category',
		    'tax_new_item'      		=> 'Add New Category',
		    'tax_new_item_name'     => 'New Category',
		    'tax_menu_name'         => 'Categories',
				'tax_custom_rewrite_slug' => 'Categories',
		    'tax_hierarchical'      => true,
		    'tax_public'      			=> true,
		    'tax_public_query'      => true,
		    'tax_show_in_menu'      => true,
		    'tax_show_ui'           => true,
		    'tax_show_admin_column' => true,
		    'tax_query_var'         => true
		
		));

		foreach ($posttype_arr as $posttype) {
	    if ($getOption) {
	      array_push($getOption, $posttype);
	    }else{
	      $getOption = [];
	      array_push($getOption, $posttype);
	    }
	  }

		return update_option('icpa_tax_settings', $getOption);
	}

	
	/**
	 * Imports the Demo Content
	 * @since 1.1.0
	 */
		public function setup_widgets() 
		{
			ini_set( 'upload_max_filesize', '30M' );
		ini_set( 'max_execution_time', '300' );
			$this->custom_posttype_option();
			$this->custom_taxonomy_option();
			do_action('custom_posttype_register');
			
		// $data_array=[];
	 //    $matchTheme=array(
	 //      'vw-black-and-white-pro' => 'sirat'
	 //    );
	 //    $newTheme = wp_get_theme();
	 //      $themename = $newTheme->get_stylesheet();
	 //      global $wpdb;
	 //      if(isset($matchTheme[$themename])){
	 //    $old_theme = $matchTheme[$themename];
	 //      $checkWord = 'theme_mods_'.$themename;
	 //      $mqr = "SELECT * FROM wp_options where option_name='$checkWord'";
	 //      $result = $wpdb->get_row($mqr);
	 //      if($result){
	 //        $optionValue = $result->option_value;
	 //        $data_array=unserialize($optionValue);
	 //      }
	 //    }
		// $theme_mods_match_id = [
	 //      'vw_black_and_white_pro_header_section_call_icon' => ['default'=> 'fas fa-phone'],
	 //      'vw_black_and_white_pro_header_section_call1' => ['default'=> '1234-56-7890'],
	 //      'vw_black_and_white_pro_header_section_email_icon' => ['default'=> 'fas fa-envelope-open'],
	 //      'vw_black_and_white_pro_header_section_email' => ['default'=> 'multipuposeexp@gmail.com'],
	 //    ];
	  //POST and update the customizer and other related data of VW Cafe Pro
      $home_id    = '';
      $vwblog_id  = '';
      $page_id    = '';
      $contact_id = '';
    
    // Create a front page and assigned the template
    
    $home_content = '';
    
    $home_title = 'Home';
    $home       = array(
        'post_type' => 'page',
        'post_title' => $home_title,
        'post_content' => $home_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'home'
    );
    $home_id    = wp_insert_post($home);
    
    //Set the home page template
    add_post_meta($home_id, '_wp_page_template', 'page-template/home-page.php');
    
    //Set the static front page
    $home = get_page_by_title('Home');
    update_option('page_on_front', $home->ID);
    update_option('show_on_front', 'page');
    
    
    // Create a blog page and assigned the template
    $vwblog_title = 'Blog';
    $blog         = array(
        'post_type' => 'page',
        'post_title' => $vwblog_title,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'blog'
    );
    $vwblog_id    = wp_insert_post($blog);
    
    //Set the blog page template
    add_post_meta($vwblog_id, '_wp_page_template', 'page-template/blog-fullwidth-extend.php');

    $vwblogleft_title = 'Blog with Left Sidebar';
    $blogleft         = array(
        'post_type' => 'page',
        'post_title' => $vwblogleft_title,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'blog-with-left-sidebar'
    );
    $vwblogleft_id    = wp_insert_post($blogleft);
    
    //Set the blog page template
    add_post_meta($vwblogleft_id, '_wp_page_template', 'page-template/blog-with-left-sidebar.php');

    $vwblogright_title = 'Blog with Right Sidebar';
    $blogright         = array(
        'post_type' => 'page',
        'post_title' => $vwblogright_title,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'blog-with-right-sidebar'
    );
    $vwblogright_id    = wp_insert_post($blogright);
    
    //Set the blog page template
    add_post_meta($vwblogright_id, '_wp_page_template', 'page-template/blog-with-right-sidebar.php');
    
    // Create a Page 
    $page_title = 'Page ';
    $content    = 'Te obtinuit ut adepto satis somno. Aliisque institoribus iter deliciae vivet vita. Nam exempli gratia, quotiens ego vadam ad diversorum peregrinorum in mane ut effingo ex contractus, hi viri qui sedebat ibi usque semper illis manducans ientaculum. Solum cum bulla ut debui; EGO youd adepto a macula proiciendi. Sed quis scit si forte quod esset optima res pro me. sicut ea quae sentio. Qui vellem cadunt off ius desk ejus! Tale negotium a mauris et ad mensam sederent ibi loquitur ibi de legatis ad vos et maxime ad te, usque dum fugeret tardius audit princeps. Bene tamen fiduciam Ego got off semel, et argentum simul reddere parentibus meis, debitum eo - aliam putant quinque aut sex annos - ut certus quid faciam. Quod suus Faciam, cum magna mutatio. Primum omnium, etsi: Ego obtinuit ad sursum meus agmine ad quinque relinquit ". Et respexit super ad terror horologium, in pectore et ';
    
    $vwpage  = array(
        'post_type' => 'page',
        'post_title' => $page_title,
        'post_content' => $content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'page'
    );
    $page_id = wp_insert_post($vwpage);
    
    //   // Create a Page 
    $pageleft_title = 'Page With Left Sidebar ';
    $content    = 'Te obtinuit ut adepto satis somno. Aliisque institoribus iter deliciae vivet vita. Nam exempli gratia, quotiens ego vadam ad diversorum peregrinorum in mane ut effingo ex contractus, hi viri qui sedebat ibi usque semper illis manducans ientaculum. Solum cum bulla ut debui; EGO youd adepto a macula proiciendi. Sed quis scit si forte quod esset optima res pro me. sicut ea quae sentio. Qui vellem cadunt off ius desk ejus! Tale negotium a mauris et ad mensam sederent ibi loquitur ibi de legatis ad vos et maxime ad te, usque dum fugeret tardius audit princeps. Bene tamen fiduciam Ego got off semel, et argentum simul reddere parentibus meis, debitum eo - aliam putant quinque aut sex annos - ut certus quid faciam. Quod suus Faciam, cum magna mutatio. Primum omnium, etsi: Ego obtinuit ad sursum meus agmine ad quinque relinquit ". Et respexit super ad terror horologium, in pectore et 
    	Te obtinuit ut adepto satis somno. Aliisque institoribus iter deliciae vivet vita. Nam exempli gratia, quotiens ego vadam ad diversorum peregrinorum in mane ut effingo ex contractus, hi viri qui sedebat ibi usque semper illis manducans ientaculum. Solum cum bulla ut debui; EGO youd adepto a macula proiciendi. Sed quis scit si forte quod esset optima res pro me. sicut ea quae sentio. Qui vellem cadunt off ius desk ejus! Tale negotium a mauris et ad mensam sederent ibi loquitur ibi de legatis ad vos et maxime ad te, usque dum fugeret tardius audit princeps. Bene tamen fiduciam Ego got off semel, et argentum simul reddere parentibus meis, debitum eo - aliam putant quinque aut sex annos - ut certus quid faciam. Quod suus Faciam, cum magna mutatio. Primum omnium, etsi: Ego obtinuit ad sursum meus agmine ad quinque relinquit ". Et respexit super ad terror horologium, in pectore et';
    
    $vwpageleft  = array(
        'post_type' => 'page',
        'post_title' => $pageleft_title,
        'post_content' => $content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'page-with-left-sidebar'
    );
    $pageleft_id = wp_insert_post($vwpageleft);
    
    add_post_meta($pageleft_id, '_wp_page_template', 'page-template/page-with-left-sidebar.php');


      // Create a Page 
    $pageright_title = 'Page With Right Sidebar ';
    $content    = 'Te obtinuit ut adepto satis somno. Aliisque institoribus iter deliciae vivet vita. Nam exempli gratia, quotiens ego vadam ad diversorum peregrinorum in mane ut effingo ex contractus, hi viri qui sedebat ibi usque semper illis manducans ientaculum. Solum cum bulla ut debui; EGO youd adepto a macula proiciendi. Sed quis scit si forte quod esset optima res pro me. sicut ea quae sentio. Qui vellem cadunt off ius desk ejus! Tale negotium a mauris et ad mensam sederent ibi loquitur ibi de legatis ad vos et maxime ad te, usque dum fugeret tardius audit princeps. Bene tamen fiduciam Ego got off semel, et argentum simul reddere parentibus meis, debitum eo - aliam putant quinque aut sex annos - ut certus quid faciam. Quod suus Faciam, cum magna mutatio. Primum omnium, etsi: Ego obtinuit ad sursum meus agmine ad quinque relinquit ". Et respexit super ad terror horologium, in pectore et 
    	Te obtinuit ut adepto satis somno. Aliisque institoribus iter deliciae vivet vita. Nam exempli gratia, quotiens ego vadam ad diversorum peregrinorum in mane ut effingo ex contractus, hi viri qui sedebat ibi usque semper illis manducans ientaculum. Solum cum bulla ut debui; EGO youd adepto a macula proiciendi. Sed quis scit si forte quod esset optima res pro me. sicut ea quae sentio. Qui vellem cadunt off ius desk ejus! Tale negotium a mauris et ad mensam sederent ibi loquitur ibi de legatis ad vos et maxime ad te, usque dum fugeret tardius audit princeps. Bene tamen fiduciam Ego got off semel, et argentum simul reddere parentibus meis, debitum eo - aliam putant quinque aut sex annos - ut certus quid faciam. Quod suus Faciam, cum magna mutatio. Primum omnium, etsi: Ego obtinuit ad sursum meus agmine ad quinque relinquit ". Et respexit super ad terror horologium, in pectore et';
    
    $vwpageright  = array(
        'post_type' => 'page',
        'post_title' => $pageright_title,
        'post_content' => $content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'page-with-right-sidebar'
    );
    $pageright_id = wp_insert_post($vwpageright);
    
    add_post_meta($pageright_id, '_wp_page_template', 'page-template/page-with-right-sidebar.php');
    // Create a contact page and assigned the template
    $contact_title = 'Contact';
    $contact       = array(
        'post_type' => 'page',
        'post_title' => $contact_title,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'contact'
    );
    $contact_id    = wp_insert_post($contact);
    
    //Set the blog with right sidebar template
    add_post_meta($contact_id, '_wp_page_template', 'page-template/contact.php');
    
    // Create a About page and assigned the template
  	//Set Services page

      $faq_title = 'FAQ';
      $faq = array(
	  'post_type' => 'page',
	  'post_title' => $faq_title,
	  'post_status' => 'publish',
	  'post_author' => 1,
	  'post_slug' => 'faq'
	);
    $faq_id = wp_insert_post($faq);
    add_post_meta($faq_id, '_wp_page_template', 'page-template/faq.php');

    $error_title = 'Error 404';
		  $error = array(
			'post_type' 	=> 'page',
			'post_title' 	=> $error_title,
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' 	=> 'error-404'
		);
		$error_id = wp_insert_post($error);

		//Set the blog with right sidebar template
		add_post_meta( $error_id, '_wp_page_template', 'page-template/error-404.php' );

		$typography_title = 'Typography';
		$typography = array(
			'post_type' 	=> 'page',
			'post_title' 	=> $typography_title,
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' 	=> 'typography'
		);
		$typography_id = wp_insert_post($typography);

		//Set the blog with right sidebar template
		add_post_meta( $typography_id, '_wp_page_template', 'page-template/typography-template.php' );

		 // Create a contact page and assigned the template
         $menu_title = 'About Us';
         $menu_check = get_page_by_title($menu_title);
         $menu = array(
         'post_type' => 'page',
         'post_title' => $menu_title,
         'post_status' => 'publish',
         'post_author' => 1,
         'post_slug' => 'about-us'
         );
         $menu_id = wp_insert_post($menu);

         //Set the blog with right sidebar template
         add_post_meta( $menu_id, '_wp_page_template', 'page-template/about.php' );

    // -------------- Section Ordering ---------------
      set_theme_mod('vw_black_and_white_pro_section_ordering_settings_repeater', 'banner,about-us,services,progress-bar,portfolio,our-clients,counter,newsletter,our-team,latest-post,sponsor');


      // ------------------------------ Header ---------------------------
       set_theme_mod('vw_black_and_white_pro_display_title', false);
        set_theme_mod('vw_black_and_white_pro_display_tagline', false);
       set_theme_mod('vw_black_and_white_pro_top_right_sidebar_close_icon', 'fas fa-times');
       set_theme_mod( 'vw_black_and_white_pro_top_header_menu_icon', get_template_directory_uri().'/assets/images/header/Menu-copy.png');
       set_theme_mod( 'vw_black_and_white_pro_topbar_phone_icon', get_template_directory_uri().'/assets/images/header/call-icon.png');
           set_theme_mod( 'vw_black_and_white_pro_topbar_contacts', '+00-123-456-7890' );
           set_theme_mod( 'vw_black_and_white_pro_call_texts', 'Phone:' );
          set_theme_mod( 'vw_black_and_white_pro_header_search_icon', get_template_directory_uri().'/assets/images/header/Search-copy.png');
          set_theme_mod( 'vw_black_and_white_pro_search_placeholder_text', 'Search Here' );

          set_theme_mod( 'vw_black_and_white_pro_right_sidebar_phone_icons', 'fas fa-phone-volume' );
    	set_theme_mod( 'vw_black_and_white_pro_right_sidebar_email_icons', 'fas fa-location-arrow' );
    	set_theme_mod( 'vw_black_and_white_pro_right_sidebar_location_icons', 'fas fa-map-marker-alt' );
    	
        // --------------------- banner section------------------------
           set_theme_mod( 'vw_black_and_white_pro_banner_bgimage', get_template_directory_uri().'/assets/images/banner/slider-image.png');
         set_theme_mod( 'vw_black_and_white_pro_banner_us_main_head', 'Black & White' );
         set_theme_mod( 'vw_black_and_white_pro_banner_us_sub_head', 'Lorem Ipsum is simply dummy text of the printing.' );
        
       set_theme_mod( 'vw_black_and_white_pro_banner_us_btnurl','#');
         set_theme_mod( 'vw_black_and_white_pro_banner_us_btntext', 'See More' );

         // ---------Social Icon--------------------
         set_theme_mod('vw_black_and_white_pro_banner_social_icon_link_number', 4);

        $Social_icon_pick = array('fab fa-facebook-f','fab fa-twitter','fab fa-pinterest-p','fab fa-vimeo-v');
       $Social_icon_link = array(
       	'https://www.facebook.com/',
       	'https://twitter.com/',
       	'https://www.pinterest.com/',
        'https://vimeo.com/'
        );
        for($i=1; $i<=4; $i++) {

        set_theme_mod('vw_black_and_white_pro_banner_social_icon_link'.$i, $Social_icon_link[$i-1]);
        set_theme_mod('vw_black_and_white_pro_banner_social_icon_picker' . $i, $Social_icon_pick[$i-1]);
        }
       
        // ---------------------------- about us --------------------
	
		// About Us
         set_theme_mod( 'vw_black_and_white_pro_aboutus_left_middle_image', get_template_directory_uri().'/assets/images/About/about-us-image.png');
         set_theme_mod( 'vw_black_and_white_pro_about_us_main_head', 'About US' );
           set_theme_mod( 'vw_black_and_white_pro_about_us_para1', 'Who We Are! And What We Do?' );
            set_theme_mod( 'vw_black_and_white_pro_about_us_para2', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type ' );
           set_theme_mod( 'vw_black_and_white_pro_read_more_about_btnurl', home_url( '/index.php/about-us/' ));
         set_theme_mod( 'vw_black_and_white_pro_read_more_about_btntext', 'SEE MORE' );
         set_theme_mod( 'vw_black_and_white_pro_about_us_number_border', '69' );
           set_theme_mod( 'vw_black_and_white_pro_about_us_number_right-text', 'We have 69+ years Experience in The Business' );

           // --------------------------------services -----------------------
         set_theme_mod( 'vw_black_and_white_pro_services_bgimage', get_template_directory_uri().'/assets/images/services/service-background.png');
          set_theme_mod( 'vw_black_and_white_pro_services_bgimages', get_template_directory_uri().'/assets/images/services/service-borderbg.png');
        set_theme_mod( 'vw_black_and_white_pro_our_services_titles', 'Our Services' );
         set_theme_mod( 'vw_black_and_white_pro_our_services_sub_head', 'What We Do?' );
         //Sub text
         set_theme_mod( 'vw_black_and_white_pro_services_number', 6 );
         
          
         $enames = array();
         $enames[1]='Our Services-06';
         $enames[2]='Our Services-05';
         $enames[3]='Our Services-04';
         $enames[4]='Our Services-03';
         $enames[5]='Our Services-02';
         $enames[6]='Our Services-01';
        
        for($i=1;$i<=6;$i++){
            $vw_title = $enames[$i];
            $content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard';

            // Create post object
            $my_post = array(
              'post_title'    => wp_strip_all_tags( $vw_title ),
              'post_content'  => $content,
              'post_status'   => 'publish',
               'post_type'     => 'services',
            );

            // Insert the post into the database
            $vw_post_id = wp_insert_post( $my_post );

            
            $image_url = get_template_directory_uri().'/assets/images/services/Service'.$i.'.png';

            $image_name       = 'Service'.$i.'.png';
            $upload_dir       = wp_upload_dir(); // Set upload folder
            $image_data       = file_get_contents($image_url); // Get image data
            $unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
            $filename         = basename( $unique_file_name ); // Create image file name

            // Check folder permission and define file location
            if( wp_mkdir_p( $upload_dir['path'] ) ) {
              $file = $upload_dir['path'] . '/' . $filename;
            } else {
              $file = $upload_dir['basedir'] . '/' . $filename;
            }

            // Create the image  file on the server
            file_put_contents( $file, $image_data );

            // Check image file type
            $wp_filetype = wp_check_filetype( $filename, null );

            // Set attachment data
            $attachment = array(
              'post_mime_type' => $wp_filetype['type'],
              'post_title'     => sanitize_file_name( $filename ),
              'post_content'   => '',
              'post_type'     => 'services',
              'post_status'    => 'inherit'
            );

            // Create the attachment
            $attach_id = wp_insert_attachment( $attachment, $file, $vw_post_id );

            // Include image.php
            require_once(ABSPATH . 'wp-admin/includes/image.php');

            // Define attachment metadata
            $attach_data = wp_generate_attachment_metadata( $attach_id, $file );

            // Assign metadata to attachment
            wp_update_attachment_metadata( $attach_id, $attach_data );

            // And finally assign featured image to post
            set_post_thumbnail( $vw_post_id, $attach_id );
      }
               
            //---------Feature Skill Section-------------
    set_theme_mod('vw_black_and_white_pro_feature_skill_small_heading', ' Our Specialities ');
    set_theme_mod('vw_black_and_white_pro_feature_skill_main_heading', 'Why Chooses Us?');
    
    
    set_theme_mod('vw_black_and_white_pro_feature_skill_number', 4);
    $progress_bar_title = array(
        'Adobe Photoshop',
        'Adobe Illustrator',
        'Abobe XD',
        'Corel Draw'
    );
    $progress_bar_per   = array(
        '95',
        '95',
        '95',
        '95'
    );
    for ($i = 1; $i <= 4; $i++) {
        set_theme_mod('vw_black_and_white_pro_feature_skill_progress_bar_text' . $i, $progress_bar_title[$i - 1]);
        set_theme_mod('vw_black_and_white_pro_feature_skill_progress_bar_percentage' . $i, $progress_bar_per[$i - 1]);
        set_theme_mod( 'vw_black_and_white_pro_progress_bar_icon_image'.$i, get_template_directory_uri() . '/assets/images/progress-bar/Icon'.$i.'.png');
    }

    set_theme_mod('vw_black_and_white_pro_feature_skill_numbers', 5);
    $progress_bar_titles = array(
        'High standard theme',
        'Selective reloading',
        'No coding required',
        'Multi-function theme',
        'Minimal design'
    );
    $right_progress_icon = array('fas fa-pencil-alt','fas fa-pencil-alt','fas fa-pencil-alt','fas fa-pencil-alt','fas fa-pencil-alt');
    for ($i = 1; $i <= 5; $i++) {
        set_theme_mod('vw_black_and_white_pro_feature_right_heading' . $i, $progress_bar_titles[$i - 1]);
        set_theme_mod('vw_black_and_white_pro_feature_skill_progress_bar_right_icon_img' . $i, $right_progress_icon[$i - 1]);
    }

   // --------------------------- portfolio section-----------------------
    
         set_theme_mod( 'vw_black_and_white_pro_portfolio_btntext', 'See All Projects' );
         //Sub text
         set_theme_mod( 'vw_black_and_white_pro_portfolio_number', 3 );


         $enames = array();
         $enames[1]='Black and white  Portfolio Title -03';
         $enames[2]='Black and white  Portfolio Title -02';
         $enames[3]='Black and white  Portfolio Title -01';

         for($i=1;$i<=3;$i++){
            $vw_title = $enames[$i];
            $content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.';

            // Create post object
            $my_post = array(
              'post_title'    => wp_strip_all_tags( $vw_title ),
              'post_content'  => $content,
              'post_status'   => 'publish',
               'post_type'     => 'portfolio',
            );

            // Insert the post into the database
            $vw_post_id = wp_insert_post( $my_post );
             update_post_meta( $vw_post_id, 'meta-paragraph', 'Let’s See Our Completed Projects!');
            $image_url = get_template_directory_uri().'/assets/images/portfolio/Portfolio'.$i.'.png';
            $image_name       = 'Portfolio'.$i.'.png';
            $upload_dir       = wp_upload_dir(); // Set upload folder
            $image_data       = file_get_contents($image_url); // Get image data
            $unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
            $filename         = basename( $unique_file_name ); // Create image file name

            // Check folder permission and define file location
            if( wp_mkdir_p( $upload_dir['path'] ) ) {
              $file = $upload_dir['path'] . '/' . $filename;
            } else {
              $file = $upload_dir['basedir'] . '/' . $filename;
            }

            // Create the image  file on the server
            file_put_contents( $file, $image_data );

            // Check image file type
            $wp_filetype = wp_check_filetype( $filename, null );

            // Set attachment data
            $attachment = array(
              'post_mime_type' => $wp_filetype['type'],
              'post_title'     => sanitize_file_name( $filename ),
              'post_content'   => '',
              'post_type'     => 'portfolio',
              'post_status'    => 'inherit'
            );

            // Create the attachment
            $attach_id = wp_insert_attachment( $attachment, $file, $vw_post_id );

            // Include image.php
            require_once(ABSPATH . 'wp-admin/includes/image.php');

            // Define attachment metadata
            $attach_data = wp_generate_attachment_metadata( $attach_id, $file );

            // Assign metadata to attachment
            wp_update_attachment_metadata( $attach_id, $attach_data );

            // And finally assign featured image to post
            set_post_thumbnail( $vw_post_id, $attach_id );
      }

      // ------------------------------- our clients--------------------

      set_theme_mod( 'vw_black_and_white_pro_our_client_main_heading', 'Black & White' );
      set_theme_mod( 'vw_black_and_white_pro_our_client_color-head1', 'Did everything and more' );
      set_theme_mod( 'vw_black_and_white_pro_our_client_color-head2', 'than we' );
       set_theme_mod( 'vw_black_and_white_pro_our_client_color-head3', 'expected!' );
       set_theme_mod( 'vw_black_and_white_pro_our_client_quotes1', 'fas fa-quote-left' );
    	set_theme_mod( 'vw_black_and_white_pro_our_client_quotes2', 'fas fa-quote-right' );
      //Sub text
       set_theme_mod( 'vw_black_and_white_pro_our_client_number', 3 );


         $client_title = array();
         $client_title[1]='Client Full Name 01';
         $client_title[2]='Client Full Name 02';
         $client_title[3]='Client Full Name 03';

         for($i=1;$i<=3;$i++){
            $vw_title = $client_title[$i];
            $content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.';

            // Create post object
            $my_post = array(
              'post_title'    => wp_strip_all_tags( $vw_title ),
              'post_content'  => $content,
              'post_status'   => 'publish',
               'post_type'     => 'our-client',
            );

            // Insert the post into the database
            $vw_post_id = wp_insert_post( $my_post );
             update_post_meta( $vw_post_id, 'meta-client-designation', 'Managing Director, King Corporation');
             update_post_meta( $vw_post_id, 'meta-client-description', 'Marketing Manager, KG Enterprises');
            $image_url = get_template_directory_uri().'/assets/images/our-clents/client'.$i.'.png';
            $image_name       = 'client'.$i.'.png';
            $upload_dir       = wp_upload_dir(); // Set upload folder
            $image_data       = file_get_contents($image_url); // Get image data
            $unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
            $filename         = basename( $unique_file_name ); // Create image file name

            // Check folder permission and define file location
            if( wp_mkdir_p( $upload_dir['path'] ) ) {
              $file = $upload_dir['path'] . '/' . $filename;
            } else {
              $file = $upload_dir['basedir'] . '/' . $filename;
            }

            // Create the image  file on the server
            file_put_contents( $file, $image_data );

            // Check image file type
            $wp_filetype = wp_check_filetype( $filename, null );

            // Set attachment data
            $attachment = array(
              'post_mime_type' => $wp_filetype['type'],
              'post_title'     => sanitize_file_name( $filename ),
              'post_content'   => '',
              'post_type'     => 'our-client',
              'post_status'    => 'inherit'
            );

            // Create the attachment
            $attach_id = wp_insert_attachment( $attachment, $file, $vw_post_id );

            // Include image.php
            require_once(ABSPATH . 'wp-admin/includes/image.php');

            // Define attachment metadata
            $attach_data = wp_generate_attachment_metadata( $attach_id, $file );

            // Assign metadata to attachment
            wp_update_attachment_metadata( $attach_id, $attach_data );

            // And finally assign featured image to post
            set_post_thumbnail( $vw_post_id, $attach_id );
      }

      // ----------------------------- counter-----------------------------
      
      set_theme_mod( 'vw_black_and_white_pro_counter_bgimage',get_template_directory_uri().'/assets/images/counter/counter-bg.png' );

      set_theme_mod( 'vw_black_and_white_pro_counter_sec_image',get_template_directory_uri().'/assets/images/counter/video.png' );

      set_theme_mod( 'vw_black_and_white_pro_counter_main_heading', 'Statistics' );
      set_theme_mod( 'vw_black_and_white_pro_counter_paragraph', 'Learn More About Our Success!' );
         
		set_theme_mod( 'vw_black_and_white_pro_counter_link', 'https://www.youtube.com/embed/yAoLSRbwxL8' );
        set_theme_mod( 'vw_black_and_white_pro_counter_icon',get_template_directory_uri().'/assets/images/counter/Play.png' );

		set_theme_mod( 'vw_black_and_white_pro_our_records_number', 4 );
        $record_no=array('500','99','696','999');
        $record_sufix=array('+','','','+');
        $record_title=array('Projects Completed','Satisfied Customers','Cups Of Coffee','Working Days');
        for($i=1;$i<=4;$i++)
        {
        
          set_theme_mod( 'vw_black_and_white_pro_our_records_no'.$i, $record_no[$i-1] );
          set_theme_mod( 'vw_black_and_white_pro_our_records_no_suffix'.$i,$record_sufix[$i-1]);
          set_theme_mod( 'vw_black_and_white_pro_our_records_title'.$i, $record_title[$i-1] );
        }


      // ------------------- sponsor---------------------

          set_theme_mod( 'vw_black_and_white_pro_sponsor_number', 5);
         for($i=1;$i<=5;$i++)
        {

          set_theme_mod( 'vw_black_and_white_pro_sponsor_img'.$i, get_template_directory_uri() . '/assets/images/Partners/Partner'.$i.'.png');
          set_theme_mod( 'vw_black_and_white_pro_sponsor_image_url'.$i, '#' );
        }

         // error 404
		set_theme_mod( 'vw_black_and_white_pro_error_temp_bg_images',get_template_directory_uri().'/assets/images/404-image.png' );
	
        set_theme_mod( 'vw_black_and_white_pro_404_page_title', 'Not Found' );
        set_theme_mod( 'vw_black_and_white_pro_404_page_content', 'Resource request Could not be found on this services.' );
         set_theme_mod( 'vw_black_and_white_pro_404_page_button_text', 'Back to Home Page' );
        
         //faq
        set_theme_mod( 'vw_black_and_white_pro_faq_bg_image',get_template_directory_uri().'/assets/images/faq-image.png' );
          set_theme_mod( 'vw_black_and_white_pro_faq_number', 3 );
            
             set_theme_mod( 'vw_black_and_white_pro_faq_main_heading', 'Frequently Asked Questions' ); 
              set_theme_mod( 'vw_black_and_white_pro_faq_sub_heading', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.

' ); 
              $faq_title = array("24/7 Support", "Creating Workplaces That Work","Great Change Requires Support" );
             $faq_cont = array("Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast Eros fusce nisi himenaeos fermentum nascetur netus pretium lacinia elit","Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast Eros fusce nisi himenaeos fermentum nascetur netus pretium lacinia elit","Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast Eros fusce nisi himenaeos fermentum nascetur netus pretium lacinia elit","Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast Eros fusce nisi himenaeos fermentum nascetur netus pretium lacinia elit","Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast Eros fusce nisi himenaeos fermentum nascetur netus pretium lacinia elit" );
        for($i=1; $i<=3; $i++) {
          
       set_theme_mod( 'vw_black_and_white_pro_faq_button'.$i, $faq_title[$i-1] );
         			set_theme_mod( 'vw_black_and_white_pro_faq_content'.$i, $faq_cont[$i-1]);

          }

         // ---------Social Icon--------------------
         set_theme_mod('vw_black_and_white_pro_contact_information_social_icon_link_number', 4);
       
        $contact_icon_pick = array('fab fa-facebook-f','fab fa-linkedin-in','fab fa-instagram','fas fa-basketball-ball'
        
        );
       $contact_icon_link = array(
       	'https://www.facebook.com/',
        'https://www.linkedin.com/',
        'https://www.instagram.com/',
         'https://dribbble.com/'
        );
        for($i=1; $i<=4; $i++) {

        set_theme_mod('vw_black_and_white_pro_contact_information_social_icon_link'.$i, $contact_icon_link[$i-1]);
        set_theme_mod('vw_black_and_white_pro_contact_information_social_icon_picker' . $i, $contact_icon_pick[$i-1]);
    
    }
    	/* -------------- Newsletter ---------------*/
        set_theme_mod( 'vw_black_and_white_pro_newsletter_main_heading', 'Subscribe' );
        set_theme_mod( 'vw_black_and_white_pro_newsletter_small_heading', 'Newsletter' );

         // Newsletter form shortcode
		     $cf7title = "Newsletter";
		     $cf7content = '[email* your-email placeholder "Enter your email"]	[submit "Subscribe Now"]
		    [_site_title] "[your-subject]"
            [_site_title] <vowelweb@gmail.com>
            From: [your-name] <[your-email]>
            Subject: [your-subject]

            Message Body:
            [your-message]

            -- 
            This e-mail was sent from a contact form on [_site_title] ([_site_url])
            [_site_admin_email]
            Reply-To: [your-email]

            0
            0

           [_site_title] "[your-subject]"
           [_site_title] <vowelweb@gmail.com>
           Message Body:
           [your-message]

           -- 
          This e-mail was sent from a contact form on [_site_title] ([_site_url])
          [your-email]
          Reply-To: [_site_admin_email]

          0
          0
          Thank you for your message. It has been sent.
			There was an error trying to send your message. Please try again later.
			One or more fields have an error. Please check and try again.
			There was an error trying to send your message. Please try again later.
			You must accept the terms and conditions before sending your message.
			The field is required.
			The field is too long.
			The field is too short.
			There was an unknown error uploading the file.
			You are not allowed to upload files of this type.
			The file is too big.
			There was an error uploading the file.';

		$cf7_post = array(
			'post_title'    => wp_strip_all_tags( $cf7title ),
			'post_content'  => $cf7content,
			'post_status'   => 'publish',
			'post_type'     => 'wpcf7_contact_form',
		);
		// Insert the post into the database
		$cf7post_id = wp_insert_post( $cf7_post );

		add_post_meta( $cf7post_id, "_form", '[email* your-email placeholder "Enter your email"]	[submit "Subscribe Now"]' );

		$cf7mail_data  = array(
			 '[subject]' => '[_site_title] "[your-subject]"',
		    '[sender]' => '[_site_title] <vowelweb@gmail.com>',
		    '[body]' => 'From: [your-name] <[your-email]>
		     Subject: [your-subject]

		    Message Body:
		    [your-message]

		   -- 
		    This e-mail was sent from a contact form on [_site_title] ([_site_url])',
		    '[recipient]' => '[_site_admin_email]',
		    'additional_headers' => 'Reply-To: [your-email]',
		    'attachments' =>'',
		    'use_html' => 0,
		    'exclude_blank' => 0);

		add_post_meta($cf7post_id, "_mail", $cf7mail_data);
		          // Gets term object from Tree in the database.

		$cf7shortcode = '[contact-form-7 id="'.$cf7post_id.'" title="'.$cf7title.'"]';
		set_theme_mod( 'vw_black_and_white_pro_newsletter_shortcode',$cf7shortcode );


		/* ---------- Our Team ----------*/
      set_theme_mod( 'vw_black_and_white_pro_our_team_bgimage', get_template_directory_uri().'/assets/images/Team/Eclip.png' );
    set_theme_mod( 'vw_black_and_white_pro_our_team_top_heading', 'Our Team' );
    set_theme_mod( 'vw_black_and_white_pro_our_team_main_heading', 'Our Expert Engineer' );
    $team_name = array('Member Name 03','Member Name 02','Member Name 01');
        	for($i=1;$i<=3;$i++){
         	$vw_title = $team_name[$i-1];
         	$content = 'Te obtinuit ut adepto satis somno. Aliisque institoribus iter deliciae vivet vita. Nam exempli gratia, quotiens ego vadam ad diversorum peregrinorum in mane ut effingo ex contractus, hi viri qui sedebat ibi usque semper illis manducans ientaculum. Solum cum bulla ut debui; EGO youd adepto a macula proiciendi. Sed quis scit si forte quod esset optima res pro me';

            // Create post object
         	$my_post = array(
         	  'post_title'    => wp_strip_all_tags( $vw_title ),
         	  'post_content'  => $content,
         	  'post_status'   => 'publish',
               'post_type'     => 'team',
         	);

         	// Insert the post into the database
         	$vw_post_id = wp_insert_post( $my_post );
         	// Now replace meta w/ new updated value array
           	update_post_meta( $vw_post_id, 'meta-facebookurl', 'https://www.facebook.com/');
           	update_post_meta( $vw_post_id, 'meta-twitterurl', 'https://twitter.com/');
           	update_post_meta( $vw_post_id, 'meta-pinterestsurl', 'https://www.pinterest.com/' );
           	update_post_meta( $vw_post_id, 'meta-vimeourl', 'https://vimeo.com/' );

           	$image_url = get_template_directory_uri().'/assets/images/Team/Team'.$i.'.png';

            $image_name       = 'Team'.$i.'.png';
            $upload_dir       = wp_upload_dir(); // Set upload folder
            $image_data       = file_get_contents($image_url); // Get image data
            $unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
            $filename         = basename( $unique_file_name ); // Create image file name

            // Check folder permission and define file location
            if( wp_mkdir_p( $upload_dir['path'] ) ) {
              $file = $upload_dir['path'] . '/' . $filename;
            } else {
              $file = $upload_dir['basedir'] . '/' . $filename;
            }

            // Create the image  file on the server
            file_put_contents( $file, $image_data );

            // Check image file type
            $wp_filetype = wp_check_filetype( $filename, null );

            // Set attachment data
            $attachment = array(
              'post_mime_type' => $wp_filetype['type'],
              'post_title'     => sanitize_file_name( $filename ),
              'post_content'   => '',
              'post_type'     => 'team',
              'post_status'    => 'inherit'
            );

            // Create the attachment
            $attach_id = wp_insert_attachment( $attachment, $file, $vw_post_id );

            // Include image.php
            require_once(ABSPATH . 'wp-admin/includes/image.php');

            // Define attachment metadata
            $attach_data = wp_generate_attachment_metadata( $attach_id, $file );

            // Assign metadata to attachment
            wp_update_attachment_metadata( $attach_id, $attach_data );

            // And finally assign featured image to post
            set_post_thumbnail( $vw_post_id, $attach_id );
         }

          //Latest Post
         //Section Title
         set_theme_mod( 'vw_black_and_white_pro_latestpost_title', 'Our Blog' );
          set_theme_mod('vw_black_and_white_pro_latest_blog_sub_head','Latest News');
           set_theme_mod( 'vw_black_and_white_pro_read_more_latest_btnurl', '#');
         set_theme_mod( 'vw_black_and_white_pro_read_more_latest_btntext', 'View All Posts' );
         //Section Text
         set_theme_mod('vw_black_and_white_pro_latest_postall','Continue Reading');
          set_theme_mod( 'vw_black_and_white_pro_my_blog_number', 3 );

         /*--- Latest Post---*/
          $latest_title=array('Black And White Theme Blog Title 01','Black And White Theme Blog Title 02','Black And White Theme Blog Title 03','Black And White Theme Blog Title 04','Black And White Theme Blog Title 05','Black And White Theme Blog Title 06','Black And White Theme Blog Title 07','Black And White Theme Blog Title 08','Black And White Theme Blog Title 9','Black And White Theme Blog Title 10','Black And White Theme Blog Title 11','Black And White Theme Blog Title 12','Black And White Theme Blog Title 13','Black And White Theme Blog Title 14','Black And White Theme Blog Title 15');
          for($i=1;$i<=15;$i++){
            $title = $latest_title[$i-1];
            $content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry lorem Ipsum has been the industry\'s.';
              // Create post object
            $my_post = array(
            'post_title'    => wp_strip_all_tags( $title ),
            'post_content'  => $content,
            'post_status'   => 'publish',
            'post_type'     => 'post',
            );

            // Insert the post into the database
            $vw_post_id = wp_insert_post( $my_post );

             // Gets category
			update_post_meta( $vw_post_id, 'meta-blog-que', 'Why do we use it?');
      		update_post_meta( $vw_post_id, 'meta-blog-para', "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.");

      		update_post_meta( $vw_post_id, 'meta-blog-text', "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.");

      		update_post_meta( $vw_post_id,'meta-image1',get_template_directory_uri().'/assets/images/Single-Blog/img1.png');
      		update_post_meta( $vw_post_id,'meta-image2',get_template_directory_uri().'/assets/images/Single-Blog/img2.png');
      		update_post_meta( $vw_post_id,'meta-single-banner',get_template_directory_uri().'/assets/images/Single-Blog/banner.png');

            $image_url = get_template_directory_uri().'/assets/images/Blog/blog-image'.$i.'.png';

            $image_name       = 'blog-image'.$i.'.png';
            $upload_dir       = wp_upload_dir(); // Set upload folder
            $image_data       = file_get_contents($image_url); // Get image data
            $unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
            $filename         = basename( $unique_file_name ); // Create image file name

            // Check folder permission and define file location
            if( wp_mkdir_p( $upload_dir['path'] ) ) {
              $file = $upload_dir['path'] . '/' . $filename;
            } else {
              $file = $upload_dir['basedir'] . '/' . $filename;
            }

            // Create the image  file on the server
            file_put_contents( $file, $image_data );

            // Check image file type
            $wp_filetype = wp_check_filetype( $filename, null );

            // Set attachment data
            $attachment = array(
              'post_mime_type' => $wp_filetype['type'],
              'post_title'     => sanitize_file_name( $filename ),
              'post_content'   => '',
              'post_type'     => 'post',
              'post_status'    => 'inherit'
            );

            // Create the attachment
            $attach_id = wp_insert_attachment( $attachment, $file, $post_id );

            // Include image.php
            require_once(ABSPATH . 'wp-admin/includes/image.php');

            // Define attachment metadata
            $attach_data = wp_generate_attachment_metadata( $attach_id, $file );

            // Assign metadata to attachment
            wp_update_attachment_metadata( $attach_id, $attach_data );

            // And finally assign featured image to post
            set_post_thumbnail( $vw_post_id, $attach_id );
         }

         // Insert the post into the database
			$vw_post_id = 1;
			$image_url = get_template_directory_uri().'/assets/images/blogs/dafault.png';
			$image_name       = 'dafault.png';
			$upload_dir       = wp_upload_dir(); // Set upload folder
			$image_data       = file_get_contents($image_url); // Get image data
			$unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
			$filename         = basename( $unique_file_name ); // Create image file name
			// Check folder permission and define file location
			if( wp_mkdir_p( $upload_dir['path'] ) ) {
				$file = $upload_dir['path'] . '/' . $filename;
			} else {
				$file = $upload_dir['basedir'] . '/' . $filename;
			}
			// Create the image  file on the server
			file_put_contents( $file, $image_data );
			// Check image file type
			$wp_filetype = wp_check_filetype( $filename, null );
			// Set attachment data
			$attachment = array(
				'post_mime_type' => $wp_filetype['type'],
				'post_title'     => sanitize_file_name( $filename ),
				'post_content'   => '',
				'post_type'     => 'post',
				'post_status'    => 'inherit'
			);
			// Create the attachment
			$attach_id = wp_insert_attachment( $attachment, $file, $bwt_post_id );
			// Include image.php
			require_once(ABSPATH . 'wp-admin/includes/image.php');
			// Define attachment metadata
			$attach_data = wp_generate_attachment_metadata( $attach_id, $file );
			// Assign metadata to attachment
			wp_update_attachment_metadata( $attach_id, $attach_data );
			// And finally assign featured image to post
			set_post_thumbnail( $vw_post_id, $attach_id );
    	
        // Footer
        set_theme_mod('vw_black_and_white_pro_footer_widget_section_bg_image', get_template_directory_uri() . '/assets/images/footer-background.png');

       set_theme_mod('vw_black_and_white_pro_footer_term_text_url','#');
    	set_theme_mod( 'vw_black_and_white_pro_footer_term_text', 'Terms and conditions |' );

    	set_theme_mod('vw_black_and_white_pro_footer_term_privacy_text_url','#');
    	set_theme_mod( 'vw_black_and_white_pro_footer_term_privacy_text', 'Privacy |' );

    	set_theme_mod('vw_black_and_white_pro_scroll_to_top_icon','fas fa-arrow-circle-up');
    	set_theme_mod( 'vw_black_and_white_pro_footer_copy', 'Copyright © 2022 - Black And White Theme' );

    	// Responsive
    	
    	set_theme_mod( 'vw_black_and_white_pro_res_open_menu_icon', 'fas fa-bars' );
    	set_theme_mod( 'vw_black_and_white_pro_res_close_menus_icon', 'fas fa-times' );

       // Banner Image
		
		set_theme_mod('vw_black_and_white_pro_banner_bgimages', get_template_directory_uri() . '/assets/images/banners.png');

          set_theme_mod('vw_black_and_white_pro_contact_information_main_headings','Contact Information');
		set_theme_mod('vw_black_and_white_pro_contact_information_main_texts','Fill up the contact form and our team will get back in touch with you within 24 hours.');
		
        set_theme_mod('vw_black_and_white_pro_contact_information_phone_one','+0123 4567 8910');
		
		set_theme_mod('vw_black_and_white_pro_contact_information_email1','hello@sample.com');
	    set_theme_mod('vw_black_and_white_pro_contact_information_location1','105 Street New York');

		set_theme_mod( 'vw_black_and_white_pro_contact_information_address_longitude', '79.088155' );
    	set_theme_mod( 'vw_black_and_white_pro_contact_information_address_latitude', '21.145800' );

        // Contact Information

		set_theme_mod('vw_black_and_white_pro_contact_information_main_heading','Contact Information');
		set_theme_mod('vw_black_and_white_pro_contact_information_main_text','Fill up the contact form and our team will get back in touch with you within 24 hours.');
		set_theme_mod('vw_black_and_white_pro_contact_information_icon_phones','fa fa-phone');
		set_theme_mod('vw_black_and_white_pro_contact_information_phone_one','+1 123 456 7890');
		set_theme_mod('vw_black_and_white_pro_contact_information_icon_emailss','far fa-envelope');
		set_theme_mod('vw_black_and_white_pro_contact_information_email1','hello@blackandwhite.com');
		
		set_theme_mod('vw_black_and_white_pro_contact_information_img1', get_template_directory_uri() . '/assets/images/contact-form-shape.png');

		set_theme_mod( 'vw_black_and_white_pro_contact_information_address_longitude', '79.088155' );
    	set_theme_mod( 'vw_black_and_white_pro_contact_information_address_latitude', '21.145800' );

    	// contact form shortcode
        $cf7title3 = "Contact Page";
		$cf7content3 = '
			<div class="row col-12">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<label>Name</label>
			[text* your-name placeholder "Enter Your Name"]
			<label>E-mail</label>
			[email* your-email placeholder "Enter Your E-mail"]
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<label>Messsage</label>
			[textarea your-message placeholder "Enter Your Messsage"]
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center m-0 m-auto">
			[submit "Submit"]
			</div>
			</div>

			[_site_title] "[your-subject]"
			[_site_title] <vowelweb@gmail.com>
			From: [your-name] <[your-email]>
			Subject: [your-subject]

			Message Body:
			[your-message]

			-- 
			This e-mail was sent from a contact form on [_site_title] ([_site_url])
			[_site_admin_email]
			Reply-To: [your-email]

			0
			0

			[_site_title] "[your-subject]"
			[_site_title] <vowelweb@gmail.com>
			Message Body:
			[your-message]

			-- 
			This e-mail was sent from a contact form on [_site_title] ([_site_url])
			[your-email]
			Reply-To: [_site_admin_email]

			0
			0
			Thank you for your message. It has been sent.
			There was an error trying to send your message. Please try again later.
			One or more fields have an error. Please check and try again.
			There was an error trying to send your message. Please try again later.
			You must accept the terms and conditions before sending your message.
			The field is required.
			The field is too long.
			The field is too short.
			There was an unknown error uploading the file.
			You are not allowed to upload files of this type.
			The file is too big.
			There was an error uploading the file.';

		$cf7_post3 = array(
			'post_title'    => wp_strip_all_tags( $cf7title3 ),
			'post_content'  => $cf7content3,
			'post_status'   => 'publish',
			'post_type'     => 'wpcf7_contact_form',
		);
			// Insert the post into the database
		$cf7post_id3 = wp_insert_post( $cf7_post3 );

		add_post_meta($cf7post_id3, "_form", '
			<div class="row col-12">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<label>Name</label>
			[text* your-name placeholder "Enter Your Name"]
			<label>E-mail</label>
			[email* your-email placeholder "Enter Your E-mail"]
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<label>Messsage</label>
			[textarea your-message placeholder "Enter Your Messsage"]
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center m-0 m-auto">
			[submit "Submit"]
			</div>
			</div>');

		$cf7mail_data3  = array('subject' => '[_site_title] "[your-subject]"',
			    'sender' => '[_site_title] <vowelweb@gmail.com>',
			    'body' => 'From: [your-name] <[your-email]>
			Subject: [your-subject]

			Message Body:
			[your-message]

			-- 
			This e-mail was sent from a contact form on [_site_title] ([_site_url])',
			    'recipient' => '[_site_admin_email]',
			    'additional_headers' => 'Reply-To: [your-email]',
			    'attachments' => '',
			    'use_html' => 0,
			    'exclude_blank' => 0 );

		add_post_meta($cf7post_id3, "_mail", $cf7mail_data3);
			          // Gets term object from Tree in the database.

		$cf7shortcode3 = '[contact-form-7 id="'.$cf7post_id3.'" title="'.$cf7title3.'"]';

		set_theme_mod( 'vw_black_and_white_pro_contact_information_form_code',$cf7shortcode3 );

		// About us inner page

          set_theme_mod( 'vw_black_and_white_pro_inner_about_image',get_template_directory_uri().'/assets/images/About-Us-Page/about-us-main-image.png' );
          set_theme_mod( 'vw_black_and_white_pro_inner_about_sub_head', 'Lorem Ipsum is simply dummy text of the Printing and Typesetting industry.' );
          set_theme_mod( 'vw_black_and_white_pro_inner_about_para2', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.' );
          

          set_theme_mod( 'vw_black_and_white_pro_aboutus_sec_image',get_template_directory_uri().'/assets/images/About-Us-Page/about-us-video-thumbnail.png' );
          set_theme_mod( 'vw_black_and_white_pro_aboutus_sections_sub_head', 'Lorem Ipsum is simply dummy text of the Printing and Typesetting industry.' );
          set_theme_mod( 'vw_black_and_white_pro_aboutus_sections_para2', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.' );
          set_theme_mod( 'vw_black_and_white_pro_learning_icon', 'fas fa-play' );
		set_theme_mod( 'vw_black_and_white_pro_learning_link', 'https://www.youtube.com/embed/yAoLSRbwxL8' );

        /*---------------__Blog Page----------------------*/
	    set_theme_mod('vw_black_and_white_pro_blog_category_prev_title', 'Previous');
        set_theme_mod('vw_black_and_white_pro_blog_category_next_title','Next');
      	set_theme_mod('vw_black_and_white_pro_single_page_copy_image',get_template_directory_uri() . '/assets/images/copy.png');


        // $this->$this->myFunctionplugin();
    	 $this->theme_create_customizer_nav_menu();
    	 $this->theme_create_customizer_footer_menu();
    	 // $this->theme_create_customizer_footer_menu1();
    	 // $this->theme_create_customizer_footer_menu2();
    	    $VW_Widget_Importer = new VW_Widget_Importer;
			$VW_Widget_Importer->import_widgets( $this->widget_file_url );
			exit;
		}


	public function wz_activate_vw_black_and_white_pro() {
		$vw_black_and_white_pro_license_key = $_POST['vw_black_and_white_pro_license_key'];

		$endpoint = IBTANA_THEME_LICENCE_ENDPOINT.'ibtana_client_activate_premium_theme';

		$body = [
			'theme_license_key'  => $vw_black_and_white_pro_license_key,
			'site_url'					 => site_url(),
			'theme_text_domain'	 => wp_get_theme()->get( 'TextDomain' )
		];
		$body = wp_json_encode( $body );
		$options = [
			'body'        => $body,
			'headers'     => [
				'Content-Type' => 'application/json',
			]
		];
		$response = wp_remote_post( $endpoint, $options );
		if ( is_wp_error( $response ) ) {
			ThemeWhizzie::remove_the_theme_key();
			ThemeWhizzie::set_the_validation_status('false');
			$response = array('status' => false, 'msg' => 'Something Went Wrong!');
			wp_send_json($response);
			exit;
		} else {
			$response_body = wp_remote_retrieve_body( $response );
			$response_body = json_decode($response_body);

			if ( $response_body->is_suspended == 1 ) {
				ThemeWhizzie::set_the_suspension_status( 'true' );
			} else {
				ThemeWhizzie::set_the_suspension_status( 'false' );
			}

			if ($response_body->status === false) {
				ThemeWhizzie::remove_the_theme_key();
				ThemeWhizzie::set_the_validation_status('false');
				$response = array('status' => false, 'msg' => $response_body->msg);
				wp_send_json($response);
				exit;
			} else {
				ThemeWhizzie::set_the_validation_status('true');
				ThemeWhizzie::set_the_theme_key($vw_black_and_white_pro_license_key);
				$response = array('status' => true, 'msg' => 'Theme Activated Successfully!');
				wp_send_json($response);
				exit;
			}
		}
	}



	/**
	 * Imports Ibtana Builder Demo Content
	 * @since 1.1.0
	 */
public function setup_builder() {
		$buildercontent = '';
		$resp_slug = '';
		$json_theme = array('base_theme_text_domain' => 'affiliate-review');
	    $json_args = array(
	        'method' => 'POST',
	        'headers'     => array(
	            'Content-Type'  => 'application/json'
	        ),
	        'body' => json_encode($json_theme),
	    );

	    $request_data = wp_remote_post( IBTANA_THEME_LICENCE_ENDPOINT.'get_client_ibtana_premium_theme_json_with_inner_pages',$json_args);
	    $response_json = json_decode(wp_remote_retrieve_body( $request_data));

	    // echo '<pre>'; print_r($response_json->data); echo '</pre>';

	    
	    foreach($response_json->data as $resp_json) {
		    if($resp_json->page_type='template'){
		    	$resp_slug = $resp_json->slug ; 
		    }
	    }

		$json_theme1 = array('premium_template_slug' => $resp_slug);
	    $json_args1 = array(
	        'method' => 'POST',
	        'headers'     => array(
	            'Content-Type'  => 'application/json'
	        ),
	        'body' => json_encode($json_theme1),
	    );

	    $request_data1 = wp_remote_post( IBTANA_THEME_LICENCE_ENDPOINT.'get_client_ibtana_premium_theme_json',$json_args1);
	    $response_json1 = json_decode(wp_remote_retrieve_body( $request_data1));
/*	    print_r($response_json1->data);
*/
       	$buildercontent = $response_json1->data;
       	// Blog Page
		 for($i=1;$i<=15;$i++){
            $vw_title = 'Specification for latest Android update released'.$i;
            $content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida.';
                // Create post object
            $my_post = array(
            'post_title'    => wp_strip_all_tags( $vw_title ),
            'post_content'  => $content,
            'post_status'   => 'publish',
            'post_type'     => 'post',
            );

            // Insert the post into the database
            $vw_post_id = wp_insert_post( $my_post );
             
            
            // Gets category
			update_post_meta( $vw_post_id, 'meta-blog-que', 'Why do we use it?');
      		update_post_meta( $vw_post_id, 'meta-blog-para', "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.");

      		update_post_meta( $vw_post_id, 'meta-blog-text', "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.");

      		update_post_meta( $vw_post_id,'meta-image1',get_template_directory_uri().'/assets/images/Single-Blog/img1.png');
      		update_post_meta( $vw_post_id,'meta-image2',get_template_directory_uri().'/assets/images/Single-Blog/img2.png');
      		update_post_meta( $vw_post_id,'meta-single-banner',get_template_directory_uri().'/assets/images/Single-Blog/banner.png');

      		$image_url = get_template_directory_uri().'/assets/images/blogs/blog'.$i.'.png';
          	
          	$image_name= 'blog'.$i.'.png';
           
            $upload_dir       = wp_upload_dir(); // Set upload folder
            $image_data       = file_get_contents($image_url); // Get image data
            $unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
            $filename         = basename( $unique_file_name ); // Create image file name

            // Check folder permission and define file location
            if( wp_mkdir_p( $upload_dir['path'] ) ) {
              $file = $upload_dir['path'] . '/' . $filename;
            } else {
              $file = $upload_dir['basedir'] . '/' . $filename;
            }

            // Create the image  file on the server
            file_put_contents( $file, $image_data );

            // Check image file type
            $wp_filetype = wp_check_filetype( $filename, null );

            // Set attachment data
            $attachment = array(
              'post_mime_type' => $wp_filetype['type'],
              'post_title'     => sanitize_file_name( $filename ),
              'post_content'   => '',
              'post_type'     => 'post',
              'post_status'    => 'inherit'
            );

            // Create the attachment
            $attach_id = wp_insert_attachment( $attachment, $file, $vw_post_id );

            // Include image.php
            require_once(ABSPATH . 'wp-admin/includes/image.php');

            // Define attachment metadata
            $attach_data = wp_generate_attachment_metadata( $attach_id, $file );

            // Assign metadata to attachment
            wp_update_attachment_metadata( $attach_id, $attach_data );

            // And finally assign featured image to post
            set_post_thumbnail( $vw_post_id, $attach_id );

        }

        // Insert the post into the database
			$vw_post_id = 1;
			$image_url = get_template_directory_uri().'/assets/images/blogs/dafault.png';
			$image_name       = 'dafault.png';
			$upload_dir       = wp_upload_dir(); // Set upload folder
			$image_data       = file_get_contents($image_url); // Get image data
			$unique_file_name = wp_unique_filename( $upload_dir['path'], $image_name ); // Generate unique name
			$filename         = basename( $unique_file_name ); // Create image file name
			// Check folder permission and define file location
			if( wp_mkdir_p( $upload_dir['path'] ) ) {
				$file = $upload_dir['path'] . '/' . $filename;
			} else {
				$file = $upload_dir['basedir'] . '/' . $filename;
			}
			// Create the image  file on the server
			file_put_contents( $file, $image_data );
			// Check image file type
			$wp_filetype = wp_check_filetype( $filename, null );
			// Set attachment data
			$attachment = array(
				'post_mime_type' => $wp_filetype['type'],
				'post_title'     => sanitize_file_name( $filename ),
				'post_content'   => '',
				'post_type'     => 'post',
				'post_status'    => 'inherit'
			);
			// Create the attachment
			$attach_id = wp_insert_attachment( $attachment, $file, $bwt_post_id );
			// Include image.php
			require_once(ABSPATH . 'wp-admin/includes/image.php');
			// Define attachment metadata
			$attach_data = wp_generate_attachment_metadata( $attach_id, $file );
			// Assign metadata to attachment
			wp_update_attachment_metadata( $attach_id, $attach_data );
			// And finally assign featured image to post
			set_post_thumbnail( $vw_post_id, $attach_id );
 		
        $home_id; $blog_id=''; $contact_id=''; $page_id= '';$page_title='';
		$page_slug=''; global $home_b;

		$page_title = 'Home Page';
		$page_slug = 'home-page';

       	$page_check = get_page_by_title($page_title);
       	$vw_page = array(
       		'post_type' => 'page',
       		'post_title' => $page_title,
       		'post_content'  => $buildercontent,
       		'post_status' => 'publish',
       		'post_author' => 1,
       		'post_slug' => $page_slug
       	);
       	$home_id = wp_insert_post(wp_slash($vw_page));
       	add_post_meta( $home_id, '_wp_page_template', 'page-template/ibtana-template.php' );


		$home_b = get_page_by_title( 'Home Page' );

       	update_option( 'page_on_front', $home_b->ID );
       	update_option( 'show_on_front', 'page' );


        // Create a blog page and assigned the template
        $blog_title = 'Blog';
        $blog = array(
             'post_type' => 'page',
             'post_title' => $blog_title,
             'post_status' => 'publish',
             'post_author' => 1,
             'post_slug' => 'blog'
        );
        $blog_id = wp_insert_post($blog);


        //Set the blog page template
        add_post_meta( $blog_id, '_wp_page_template', 'page-template/blog-fullwidth-extend.php' );


        // Create a Page
        if( get_page_by_title( 'Page' ) == NULL ){
         	$page_title = 'Page ';
         	$content = 'Te obtinuit ut adepto satis somno. Aliisque institoribus iter deliciae vivet vita. Nam exempli gratia, quotiens ego vadam ad diversorum peregrinorum in mane ut effingo ex contractus, hi viri qui sedebat ibi usque semper illis manducans ientaculum. Solum cum bulla ut debui; EGO youd adepto a macula proiciendi. Sed quis scit si forte quod esset optima res pro me. sicut ea quae sentio. Qui vellem cadunt off ius desk ejus! Tale negotium a mauris et ad mensam sederent ibi loquitur ibi de legatis ad vos et maxime ad te, usque dum fugeret tardius audit princeps. Bene tamen fiduciam Ego got off semel';

         	$page_check = get_page_by_title($page_title);
        	$vw_page = array(
	         	'post_type' => 'page',
	         	'post_title' => $page_title,
	         	'post_content'  => $content,
	         	'post_status' => 'publish',
	         	'post_author' => 1,
	         	'post_slug' => 'page'
        	);
       		$page_id = wp_insert_post($vw_page);
         }
        

  //       // Contact Information

		// set_theme_mod('vw_black_and_white_pro_contact_information_main_heading','Contact Information');
		// set_theme_mod('vw_black_and_white_pro_contact_information_main_text','Fill up the contact form and our team will get back in touch with you within 24 hours.');
		// set_theme_mod('vw_black_and_white_pro_contact_information_icon_phones','fa fa-phone');
		// set_theme_mod('vw_black_and_white_pro_contact_information_phone_one','+1 123 456 7890');
		// set_theme_mod('vw_black_and_white_pro_contact_information_icon_emailss','far fa-envelope');
		// set_theme_mod('vw_black_and_white_pro_contact_information_email1','hello@blackandwhite.com');
		
		// set_theme_mod('vw_black_and_white_pro_contact_information_img1', get_template_directory_uri() . '/assets/images/contact-form-shape.png');

		// set_theme_mod( 'vw_black_and_white_pro_contact_information_address_longitude', '79.088155' );
  //   	set_theme_mod( 'vw_black_and_white_pro_contact_information_address_latitude', '21.145800' );

    	// contact form shortcode
        $cf7title3 = "Contact Page";
		$cf7content3 = '
			<div class="row col-12">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<label>Name</label>
			[text* your-name placeholder "Enter Your Name"]
			<label>E-mail</label>
			[email* your-email placeholder "Enter Your E-mail"]
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<label>Messsage</label>
			[textarea your-message placeholder "Enter Your Messsage"]
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center m-0 m-auto">
			[submit "Submit"]
			</div>
			</div>

			[_site_title] "[your-subject]"
			[_site_title] <vowelweb@gmail.com>
			From: [your-name] <[your-email]>
			Subject: [your-subject]

			Message Body:
			[your-message]

			-- 
			This e-mail was sent from a contact form on [_site_title] ([_site_url])
			[_site_admin_email]
			Reply-To: [your-email]

			0
			0

			[_site_title] "[your-subject]"
			[_site_title] <vowelweb@gmail.com>
			Message Body:
			[your-message]

			-- 
			This e-mail was sent from a contact form on [_site_title] ([_site_url])
			[your-email]
			Reply-To: [_site_admin_email]

			0
			0
			Thank you for your message. It has been sent.
			There was an error trying to send your message. Please try again later.
			One or more fields have an error. Please check and try again.
			There was an error trying to send your message. Please try again later.
			You must accept the terms and conditions before sending your message.
			The field is required.
			The field is too long.
			The field is too short.
			There was an unknown error uploading the file.
			You are not allowed to upload files of this type.
			The file is too big.
			There was an error uploading the file.';

		$cf7_post3 = array(
			'post_title'    => wp_strip_all_tags( $cf7title3 ),
			'post_content'  => $cf7content3,
			'post_status'   => 'publish',
			'post_type'     => 'wpcf7_contact_form',
		);
			// Insert the post into the database
		$cf7post_id3 = wp_insert_post( $cf7_post3 );

		add_post_meta($cf7post_id3, "_form", '
			<div class="row col-12">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<label>Name</label>
			[text* your-name placeholder "Enter Your Name"]
			<label>E-mail</label>
			[email* your-email placeholder "Enter Your E-mail"]
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<label>Messsage</label>
			[textarea your-message placeholder "Enter Your Messsage"]
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 text-center m-0 m-auto">
			[submit "Submit"]
			</div>
			</div>');

		$cf7mail_data3  = array('subject' => '[_site_title] "[your-subject]"',
			    'sender' => '[_site_title] <vowelweb@gmail.com>',
			    'body' => 'From: [your-name] <[your-email]>
			Subject: [your-subject]

			Message Body:
			[your-message]

			-- 
			This e-mail was sent from a contact form on [_site_title] ([_site_url])',
			    'recipient' => '[_site_admin_email]',
			    'additional_headers' => 'Reply-To: [your-email]',
			    'attachments' => '',
			    'use_html' => 0,
			    'exclude_blank' => 0 );

		add_post_meta($cf7post_id3, "_mail", $cf7mail_data3);
			          // Gets term object from Tree in the database.

		$cf7shortcode3 = '[contact-form-7 id="'.$cf7post_id3.'" title="'.$cf7title3.'"]';

		set_theme_mod( 'vw_black_and_white_pro_contact_information_form_code',$cf7shortcode3 );


		


		// Newsletter form shortcode
		     $cf7title = "Newsletter";
		     $cf7content = '[email* your-email placeholder "Input your email here"]	[submit "Submit"]
		    [_site_title] "[your-subject]"
            [_site_title] <vowelweb@gmail.com>
            From: [your-name] <[your-email]>
            Subject: [your-subject]

            Message Body:
            [your-message]

            -- 
            This e-mail was sent from a contact form on [_site_title] ([_site_url])
            [_site_admin_email]
            Reply-To: [your-email]

            0
            0

           [_site_title] "[your-subject]"
           [_site_title] <vowelweb@gmail.com>
           Message Body:
           [your-message]

           -- 
          This e-mail was sent from a contact form on [_site_title] ([_site_url])
          [your-email]
          Reply-To: [_site_admin_email]

          0
          0
          Thank you for your message. It has been sent.
			There was an error trying to send your message. Please try again later.
			One or more fields have an error. Please check and try again.
			There was an error trying to send your message. Please try again later.
			You must accept the terms and conditions before sending your message.
			The field is required.
			The field is too long.
			The field is too short.
			There was an unknown error uploading the file.
			You are not allowed to upload files of this type.
			The file is too big.
			There was an error uploading the file.';

		$cf7_post = array(
			'post_title'    => wp_strip_all_tags( $cf7title ),
			'post_content'  => $cf7content,
			'post_status'   => 'publish',
			'post_type'     => 'wpcf7_contact_form',
		);
		// Insert the post into the database
		$cf7post_id = wp_insert_post( $cf7_post );

		add_post_meta( $cf7post_id, "_form", '[email* your-email placeholder "Input your email here"]	[submit "Submit"]' );

		$cf7mail_data  = array(
			 '[subject]' => '[_site_title] "[your-subject]"',
		    '[sender]' => '[_site_title] <vowelweb@gmail.com>',
		    '[body]' => 'From: [your-name] <[your-email]>
		     Subject: [your-subject]

		    Message Body:
		    [your-message]

		   -- 
		    This e-mail was sent from a contact form on [_site_title] ([_site_url])',
		    '[recipient]' => '[_site_admin_email]',
		    'additional_headers' => 'Reply-To: [your-email]',
		    'attachments' =>'',
		    'use_html' => 0,
		    'exclude_blank' => 0);

		add_post_meta($cf7post_id, "_mail", $cf7mail_data);
		          // Gets term object from Tree in the database.

		$cf7shortcode = '[contact-form-7 id="'.$cf7post_id.'" title="'.$cf7title.'"]';
    	
        // Footer

       set_theme_mod('vw_black_and_white_pro_footer_term_text_url','#');
    	set_theme_mod( 'vw_black_and_white_pro_footer_term_text', 'Terms and conditions |' );

    	set_theme_mod('vw_black_and_white_pro_footer_term_privacy_text_url','#');
    	set_theme_mod( 'vw_black_and_white_pro_footer_term_privacy_text', 'Privacy |' );

    	set_theme_mod('vw_black_and_white_pro_scroll_to_top_icon','fas fa-arrow-circle-up');
    	set_theme_mod( 'vw_black_and_white_pro_footer_copy', 'All Rights Reserved 2022 Designer Pro Theme' );
        
           if(isset($home_b->ID)){
        	echo json_encode(['home_page_id'=>$home_b->ID,'home_page_url'=>get_edit_post_link( $home_b->ID, '' )]);
        }

       	 $this->theme_create_customizer_nav_menu();
    	 $this->theme_create_customizer_footer_menu();
    	 // $this->theme_create_customizer_footer_menu1();
       	$VW_Widget_Importer = new VW_Widget_Importer;
		$VW_Widget_Importer->import_widgets( $this->widget_file_url );

		exit;

	}


	// ------------ Ibtana Activation Close -----------
	//guidline for about theme
	public function vw_black_and_white_pro_mostrar_guide() {

		$display_string = '';

		// Check the validation Start
		$vw_black_and_white_pro_license_key = ThemeWhizzie::get_the_theme_key();
		$endpoint = IBTANA_THEME_LICENCE_ENDPOINT.'ibtana_client_premium_theme_check_activation_status';
		$body = [
			'theme_license_key'  => $vw_black_and_white_pro_license_key,
			'site_url'					 => site_url(),
			'theme_text_domain'	 => wp_get_theme()->get( 'TextDomain' )
		];
		$body = wp_json_encode( $body );
		$options = [
			'body'        => $body,
			'headers'     => [
				'Content-Type' => 'application/json',
			]
		];
		$response = wp_remote_post( $endpoint, $options );
		if ( is_wp_error( $response ) ) {
			// ThemeWhizzie::set_the_validation_status('false');
		} else {
			$response_body = wp_remote_retrieve_body( $response );
			$response_body = json_decode($response_body);

			if ( $response_body->is_suspended == 1 ) {
				ThemeWhizzie::set_the_suspension_status( 'true' );
			} else {
				ThemeWhizzie::set_the_suspension_status( 'false' );
			}
			
			$display_string = isset($response_body->display_string) ? $response_body->display_string : '';

			if ($display_string != '') {
				if (strpos($display_string, '[THEME_NAME]') !== false) {
					$display_string = str_replace("[THEME_NAME]", "VW Black And White Pro", $display_string);
				}
				if (strpos($display_string, '[THEME_PERMALINK]') !== false) {
					$display_string = str_replace("[THEME_PERMALINK]", "https://www.vwthemes.com/themes/bakery-wordpress-theme/", $display_string);
				}
			}

			echo '<div class="notice is-dismissible error thb_admin_notices">' . $display_string . '</div>';

			if ($response_body->status === false) {
				ThemeWhizzie::set_the_validation_status('false');
			} else {
				ThemeWhizzie::set_the_validation_status('true');
			}
		}
		// Check the validation END

		$theme_validation_status = ThemeWhizzie::get_the_validation_status();

		//custom function about theme customizer
		$return = add_query_arg( array()) ;
		$theme = wp_get_theme( 'vw-black-and-white-pro' );

		?>

		<div class="wrapper-info get-stared-page-wrap">

			<div class="wrapper-info-content">
				<h2><?php _e( 'Welcome to VW Black And White Pro', 'vw-black-and-white-pro' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
				<p><?php _e('All our WordPress themes are modern, minimalist, 100% responsive, seo-friendly,feature-rich, block based and multipurpose that best suit designers, bloggers and other professionals who are working in the creative fields.','vw-black-and-white-pro'); ?></p>
			</div>
			<div class="tab-sec theme-option-tab">
				<div class="tab">
					<button class="tablinks active" onclick="openCity(event, 'theme_activation')" data-tab="theme_activation"><?php _e( 'Key Activation', 'vw-black-and-white-pro' ); ?></button>
					<button class="tablinks wizard-tab" onclick="openCity(event, 'demo_offer')" data-tab="demo_offer"><?php _e( 'Setup Wizard', 'vw-black-and-white-pro' ); ?></button>
					<button class="tablinks" onclick="openCity(event, 'theme_info')" data-tab="theme_info"><?php _e( 'Support', 'vw-black-and-white-pro' ); ?></button>
					<button class="tablinks" onclick="openCity(event, 'plugins')" data-tab="plugins"><?php _e( 'Plugins', 'vw-black-and-white-pro' ); ?></button>
					<button class="tablinks other-product-tab" onclick="openCity(event, 'others_theme')"><?php esc_html_e( 'All Themes', 'vw-black-and-white-pro' ); ?></button>
				</div>

				<!-- Tab content -->
				<div id="theme_activation" class="tabcontent open">

					<div class="theme_activation-wrapper">
						<div class="theme_activation_spinner">
							<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin:auto;background:#fff;display:block;" width="200px" height="200px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
								<g transform="translate(50,50)">
								  <g transform="scale(0.7)">
								  <circle cx="0" cy="0" r="50" fill="#0f81d0"></circle>
								  <circle cx="0" cy="-28" r="15" fill="#cfd7dd">
								    <animateTransform attributeName="transform" type="rotate" dur="1s" repeatCount="indefinite" keyTimes="0;1" values="0 0 0;360 0 0"></animateTransform>
								  </circle>
								  </g>
								</g>
							</svg>
						</div>
						<div class="theme-wizard-key-status">
							<?php
								if ( $theme_validation_status === 'false' ) {
									esc_html_e('Theme License Key is not activated!','vw-black-and-white-pro');
								} else {
									esc_html_e('Theme License is Activated!','vw-black-and-white-pro');
								}
							?>
						</div>
						<?php $this->activation_page(); ?>
					</div>
				</div>
				<div id="demo_offer" class="tabcontent">
					<?php $this->wizard_page(); ?>
				</div>
				<div id="theme_info" class="tabcontent">
					<div class="col-left-inner">
						<h3><?php _e( 'VW Black And White Pro Information', 'vw-black-and-white-pro' ); ?></h3>
						<hr class="h3hr">
						<h4><?php _e( 'Theme Documentation', 'vw-black-and-white-pro' ); ?></h4>
						<p><?php _e( 'If you need any assistance regarding setting up and configuring the Theme, our documentation is there.', 'vw-black-and-white-pro' ); ?></p>
						<div class="info-link">
							<a href="<?php echo esc_url( vw_black_and_white_pro_THEME_DOC ); ?>" target="_blank"> <?php _e( 'Documentation', 'vw-black-and-white-pro' ); ?></a>
						</div>
						<hr>
						<h4><?php _e('Having Trouble, Need Support?', 'vw-black-and-white-pro'); ?></h4>
						<p> <?php _e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'vw-black-and-white-pro'); ?></p>
						<div class="info-link">
							<a href="<?php echo esc_url( vw_black_and_white_pro_SUPPORT ); ?>" target="_blank"><?php _e('Support Forum', 'vw-black-and-white-pro'); ?></a>
						</div>
						<hr>
						<h4><?php _e('Reviews & Testimonials', 'vw-black-and-white-pro'); ?></h4>
						<p> <?php _e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'vw-black-and-white-pro'); ?>  </p>
						<div class="info-link">
							<a href="<?php echo esc_url( vw_black_and_white_pro_REVIEW ); ?>" target="_blank"><?php _e('Reviews', 'vw-black-and-white-pro'); ?></a>
						</div>
					</div>
					<div class="col-right-inner">
						<div id="vw-demo-setup-guid">
							<h3><?php esc_html_e('Checkout our setup videos','vw-black-and-white-pro'); ?></h3><hr />
							<ul>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/nLB9E6BBBv0"><span class="dashicons dashicons-welcome-widgets-menus"></span>Setup Menu</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/gjccwcAK47o"><span class="dashicons dashicons-email-alt"></span>Setup Contact Page</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/7BvTpLh-RB8"><span class="dashicons dashicons-editor-table"></span>Setup Widgets</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/Mox298rk0Qo"><span class="dashicons dashicons-share"></span>Setup Social Icon</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/pgX2jlpXVqk"><span class="dashicons dashicons-wordpress-alt"></span>Install WordPress Theme</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/8UxkXkix-ic"><span class="dashicons dashicons-admin-users"></span>Create WordPress User</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/1xGlbWOzQBg"><span class="dashicons dashicons-image-flip-horizontal"></span>Setup Slider</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/pJFF_wjdvcA"><span class="dashicons dashicons-database"></span>WordPress Backup</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/xXdnUTPG_6A"><span class="dashicons dashicons-instagram"></span>Connect Instagram</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/leLBzmbvdQQ"><span class="dashicons dashicons-table-col-delete"></span>Fix 404 Error</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/OPBONJBtO6g"><span class="dashicons dashicons-admin-page"></span>Setup Template Pages</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/jqG2eRjgPa4"><span class="dashicons dashicons-video-alt3"></span>Setup Youtube Video</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/ovcok3FPRto"><span class="dashicons dashicons-welcome-add-page"></span>Setup Shortcode Pages</a>
								</li>
								<li>
									<a href="javascript:void(0);" doc-video-url="https://www.youtube.com/embed/O6elK2kSHQw"><span class="dashicons dashicons-images-alt2"></span>Setup Gallery Plugin</a>
								</li>
							</ul>
						</div>
					</div>
				</div>
				</div>
				<div class="wz-video-model">
					<span class="dashicons dashicons-no"></span>
					<iframe width="100%" src="" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
				</div>
				<div id="plugins" class="tabcontent">
					<div class="wizard-plugin-wrapper">
						<div class="o-product-row">
							<div class="plugin-col ibtana-plugin-col">
								<img src="<?php echo esc_url(get_template_directory_uri().'/theme-wizard/assets/images/banner-772x250.png'); ?>">
								<h3><?php echo esc_html('Ibtana - WordPress Website Builder Plugin'); ?></h3>
								<p><?php echo esc_html('Ibtana Gutenberg Editor has ready made eye catching responsive templates build with custom blocks and options to extend Gutenberg’s default capabilities. You can easily import demo content for the block or templates with a single click'); ?></p>
								<?php
								$plugin_ins = Vw_Premium_Theme_Plugin_Activation_Settings::get_instance();
								$vw_theme_actions = $plugin_ins->recommended_actions;

								if ($vw_theme_actions): foreach ($vw_theme_actions as $key => $vw_theme_actionValue):
								?>
								<div class="ibtana-activation-btn">
									<?php echo wp_kses_post($vw_theme_actionValue['link']); ?>
								</div>
								<?php endforeach;
				        		endif; ?>
							</div>
								<div class="plugin-col ibtana-plugin-col">
								<img src="<?php echo esc_url(get_template_directory_uri().'/theme-wizard/assets/images/Ibtana-ecommerce-banner.png'); ?>">
								<h3><?php echo esc_html('Ibtana – Ecommerce Product Addons Plugin'); ?></h3>
								<p><?php echo esc_html('Ibtana – Ecommerce Product Addons is excellent for designing a highly customized product page that shows your products in a more prominent and interesting way. With these product add ons, creating unique product pages is now possible. '); ?></p>
								<a href="<?php echo esc_url('https://www.vwthemes.com/plugins/woocommerce-product-add-ons/'); ?>"><?php echo esc_html('Buy Now'); ?></a>
							</div>
							<div class="plugin-col">
								<img src="<?php echo esc_url(get_template_directory_uri().'/theme-wizard/assets/images/VWThemes_banner_plugin.png'); ?>">
								<h3><?php echo esc_html('Title Banner Image Plugin'); ?></h3>
								<p><?php echo esc_html('If you are interested in adding the banner images, you check VW Title Banner Plugin. Its main speciality is that it permits user the addition of banner image on post, custom post or any page. '); ?></p>
								<a href="<?php echo esc_url('https://www.vwthemes.com/premium-plugin/vw-title-banner-plugin/'); ?>"><?php echo esc_html('Buy Now'); ?></a>
							</div>
							<div class="plugin-col">
								<img src="<?php echo esc_url(get_template_directory_uri().'/theme-wizard/assets/images/gallery_plugin_banner.png'); ?>">

								<h3><?php echo esc_html('VW Gallery Images Plugin'); ?></h3>
								<p><?php echo esc_html('The VW Gallery Plugin is an amazing WordPress gallery plugin. It helps you in creating the elegant gallery within few minutes. The VW Gallery plugin offers the advantage of displaying multiple galleries on a single page or post.'); ?></p>
								<a href="<?php echo esc_url('https://www.vwthemes.com/premium-plugin/vw-gallery-plugin/'); ?>"><?php echo esc_html('Buy Now'); ?></a>
							</div>

						</div>
					</div>
				</div>
				<div id="others_theme" class="tabcontent">
					<script>

						var data_post={"para":"1"};

					    jQuery.ajax({
					      method: "POST",
					      url: "https://www.vwthemes.com/wp-json/ibtana-licence/v2/get_modal_contents",
					      data: JSON.stringify(data_post),
					      dataType: 'json',
					      contentType: 'application/json',
					    }).done(function( data ) {
					    	/*console.log(data);*/
					    	var premium_data = data.data.products;
					    	for (var i = 0; i < premium_data.length; i++) {
						          var premium_product = premium_data[i];
						          var card_content = `<div class="o-products-col" data-id="`+premium_product.id+`">
						          	<div class="o-products-image">
						          		<img src="`+premium_product.image+`">
						          	</div>
						          	<h3>`+premium_product.title+`</h3>
						          	<a href="`+premium_product.permalink+`" target="_blank">Buy Now</a>
						          	<a href="`+premium_product.demo_url+`" target="_blank">View Demo</a>
						          </div>`;
						        jQuery('.wz-spinner-wrap').css('display','none');
	          					jQuery('#other-products .o-product-row').append(card_content);
	        				}

	        				var premium_category = data.data.sub;
	        				var active_class=""
	        				/*console.log(premium_category.length);*/
					    	for (let i = 0; i < premium_category.length; i++) {
					    		if(i==0){
					    			active_class="active";
					    		}else{
					    			active_class="";
					    		}
				    			let premium_product = premium_category[i];
					          	let card_content = `<li data-ids="`+premium_product.product_ids+`" onclick="other_products(this);" class="`+active_class+`">
					          		`+premium_product.name+`<span class="badge badge-info">`+premium_product.product_ids.length+`</span>
					          	</li>`;
          						jQuery('.o-product-col-1 ul').append(card_content);
					    	}
					    });

					    function other_products(content){

					    	jQuery('.o-product-col-1 ul li').attr('class','');
					        content.classList.add("active");
				            var data_ids = jQuery(content).attr('data-ids');

				            var id_arr = data_ids.split(',');
				            jQuery('.o-product-row .o-products-col[data-id]').hide();
				            for (var i = 0; i < id_arr.length; i++) {
				                var single_id = id_arr[i];
				                jQuery('.o-product-row .o-products-col[data-id="'+single_id+'"]').show();
				            }

					    }

					</script>
					<div id="other-products">
						<div class="wz-spinner-wrap">
							<div class="lds-dual-ring"></div>
						</div>
						<div class="o-product-main-row">
							<div class="o-product-col-1">
								<ul>

								</ul>
							</div>
							<div class="o-product-col-2">
								<div class="social-theme-search">
				                    <input class="themesearchinput" type="text" placeholder="Search Theme Here">
				                </div>
								<div class="o-product-row" style="clear: both;">

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	<?php }


	// Add a Custom CSS file to WP Admin Area
	public function vw_black_and_white_pro_admin_theme_style() {
		wp_enqueue_style( 'vw-black-and-white-pro-font', $this->vw_black_and_white_pro_admin_font_url(), array() );
		wp_enqueue_style('custom-admin-style', get_template_directory_uri() . '/theme-wizard/getstarted/getstart.css');
		//( 'tab', get_template_directory_uri() . '/theme-wizard/getstarted/js/tab.js' );
	}

	// Theme Font URL
	public function vw_black_and_white_pro_admin_font_url() {
		$font_url = '';
		$font_family = array();
		$font_family[] = 'Muli:300,400,600,700,800,900';

		$query_args = array(
			'family'	=> urlencode(implode('|',$font_family)),
		);
		$font_url = add_query_arg($query_args,'//fonts.googleapis.com/css');
		return $font_url;
	}
}