<?php
/**
* Template part for displaying left sidebar content
*
* @package vw-black-and-white-pro
*/
/*header left sidebar*/
$vw_black_and_white_pro_top_right_sidebar_enable = get_theme_mod( 'vw_black_and_white_pro_top_right_sidebar_enable' );
if ( 'Disable' == $vw_black_and_white_pro_top_right_sidebar_enable ) {
  return;
}
if( get_theme_mod('vw_black_and_white_pro_top_right_sidebar_bgcolor','') ) {
  $background_setting = 'background-color:'.esc_attr(get_theme_mod('vw_black_and_white_pro_top_right_sidebar_bgcolor','')).';';
}elseif( get_theme_mod('vw_black_and_white_pro_top_right_sidebar_bgimage','') ){
  $background_setting = 'background-image:url(\''.esc_url(get_theme_mod('vw_black_and_white_pro_top_right_sidebar_bgimage')).'\')';
}else{
  $background_setting = '';
}
?>
<div id="top-header-sidebar" class="" style="<?php echo esc_attr($background_setting);  ?>">
  <div class="header-left-sticky-title">
    <i class="<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_top_right_sidebar_close_icon')); ?> text-center header-right-menus"></i>
  </div>
  <?php 
  if ( is_user_logged_in() ) {
    // Get current logged in user details
    $current_user = wp_get_current_user();

    /**
    * @example Safe usage:
    * $current_user = wp_get_current_user();
    * if ( ! $current_user->exists() ) {
    *     return;
    * }
    */
    ?>
    <div class="name-mail ps-5 ms-2">
      <div class="user-login-image"><?php echo get_avatar( $current_user->ID );?></div>
      <div class="dis-name">
        <?php echo 'User display name: ' . $current_user->display_name . '<br />';?>
      </div>
      <div class="dis-mail">
        <?php echo 'User email: ' . $current_user->user_email . '<br />';?>
      </div>
    </div>
    <div class="dis-mail-log ps-5 ms-2">
      <a href="<?php echo esc_url( wp_logout_url() ); ?>">Logout</a>
    </div>
    <?php }
    else {
      echo do_shortcode('[vivid-login-page]');
    }
    ?>
  <div class="container <?php echo is_user_logged_in() ? "logged-in-sidebar" : "logged-out-sidebar"; ?>">
    <div class="row contact-box-inner">
      <div class="col-lg-12 col-md-12 col-sm-12 col-12  contact-boxes">
        <div class="contact-info-box ps-5 pt-5">
          <div class="social-right-sidebar mt-2 pb-3">
            <div class="socialbox-side">
              <?php if ( get_theme_mod('vw_black_and_white_pro_banner_social_icon',true) != "" ) {?>
              <?php
               $Social_icon=get_theme_mod('vw_black_and_white_pro_banner_social_icon_link_number');
               for($i=1;$i<=$Social_icon;$i++)
               { ?>
               <a class="social_icons" href="<?php echo esc_url( get_theme_mod( 'vw_black_and_white_pro_banner_social_icon_link'.$i ) ); ?>" target="_blank">
               <i class="<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_banner_social_icon_picker'.$i)); ?> align-middle"></i></a> 
               <?php 
              } 
              ?> 
             <?php } ?>
           </div>
           </div>
          <h2 class="mt-lg-3 pb-3">
            <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_main_headings')); ?>
          </h2>
          <p class="contact-heads">
            <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_main_texts')); ?>
          </p>
          <div class="row col-12 mt-4 pt-2 mb-4 pb-2">
            <div class="col-lg-2 col-sm-2 col-2">
              <i class="<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_right_sidebar_phone_icons')); ?>"></i>
            </div>
            <div class="col-lg-10 col-sm-10 col-10">
              <?php $vw_black_and_white_pro_contact_information_contact_option = get_theme_mod( 'vw_black_and_white_pro_contact_information_options','Call');
              if($vw_black_and_white_pro_contact_information_contact_option == 'Call'){ ?>
                <a href='tel:<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_phone_one')); ?>' target='_blank'>
                  <p class="m-0 phn-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_phone_one')); ?></p>
                </a>
              <?php } else if ($vw_black_and_white_pro_contact_information_contact_option == 'Whatsapp') { ?>
                <a href='https://wa.me/<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_phone_one')); ?>' target='_blank'>
                  <p class="m-0 phn-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_phone_one')); ?></p>
                </a>  
              <?php } ?>  
            </div>
          </div>
          <div class="row col-12 mt-2">
            <div class="col-lg-2 col-sm-2 col-2">
              <i class="<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_right_sidebar_email_icons')); ?>"></i>
            </div>
            <div class="col-lg-10 col-sm-10 col-10">
              <a href="mailto:<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_email1')); ?>">
                <p class="m-0 email-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_email1')); ?></p>
              </a>
            </div>
          </div>
          <div class="row col-12 mt-4 pt-2">
            <div class="col-lg-2 col-sm-2 col-2">
              <i class="<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_right_sidebar_location_icons')); ?>"></i>
            </div>
            <div class="col-lg-10 col-sm-10 col-10">
              <a href="http://maps.google.com/?q=1200<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_location1')); ?>" target="_blank">
                <p class="m-0 location-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_location1')); ?></p>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
