<?php
/**
 * The Template for displaying all single posts.
 *
 * @package vw-black-and-white-pro
 */
get_header();
?>
<div class="">
	<div class="row mt-5" id="single_post">
		
			<?php if ( get_theme_mod('vw_black_and_white_pro_blog_featured_image_enable',true) == "1" ) { ?>
				<div class="feature-box">
					<?php if(get_post_meta($post->ID,'meta-single-banner',true)) { ?>
		                 <img src="<?php echo esc_html(get_post_meta($post->ID,'meta-single-banner',true)); ?>" alt="Banner Image">
		            <?php } ?>
				</div>
			<?php } ?>
		
		<div class="container">
			<div class="content_page col-lg-10 col-md-10 col-sm-11 col-md-7 mt-5 mx-auto">
			<?php while ( have_posts() ) : the_post(); ?>
				<?php gt_set_post_view(); ?>
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="content_boxes text-lg-start text-md-start text-center text-sm-start mx-sm-5 mx-3 pt-4 px-sm-5 px-2">
												<div class="single-page-title px-xl-5 px-lg-4 mx-xl-5 mx-lg-4">
							<?php the_title(); ?>
						</div>
						<div class="row single-page-metabox px-xl-5 px-lg-4 mx-xl-5 mx-lg-4 py-4">
							<?php if ( get_theme_mod('vw_black_and_white_pro_general_settings_post_author',true) == "1" ) { ?>

								<div class="col-lg-2 single-author-image text-lg-start text-md-center text-sm-center text-center">
									<img src="<?php echo esc_url( get_avatar_url( $current_user->ID ) ); ?>">
										<a>
											<span><?php the_author(); ?></span>
										</a>

								</div>
								
							<?php } ?>
							<div class="col-lg-2 text-lg-start text-md-center text-sm-center text-center single-date-box position-relative">
								<?php if ( get_theme_mod('vw_black_and_white_pro_general_settings_post_date',true) == "1" ) { ?>
									
						            <span class="entry-date">
						            <?php the_time( 'd M Y' ) ?>
						            </span>
					             <?php } ?>
							</div>
							<div class="col-xxl-5 col-lg-4 col-lg-4 col-md-4 col-sm-4 col-4 text-lg-start text-md-center text-sm-center text-center single-mob">
								<?php if ( get_theme_mod('vw_black_and_white_pro_general_settings_post_comments',true) == "1" ) { ?>
						            <span class="entry-comments"> 
						            <?php comments_number( 'Comment 0', 'Comment 1', 'Comments % ' ); ?>
						            </span>
				            	<?php } ?>
							</div>
						</div>
						
						<div class="single-post-content px-xl-5 px-lg-4 mx-xl-5 mx-lg-4 pt-4">
							<div class="pe-xl-4 pe-lg-0">
								<?php the_content();?>
							</div>
								
							
						</div>

						<div class="meta-box-question px-xl-5 px-lg-4 mx-xl-5 mx-lg-4 py-3">
							<?php echo esc_html(get_post_meta(get_the_ID(),'meta-blog-que',true)); ?>
						</div>

						<div class="single-post-content px-xl-5 px-lg-4 mx-xl-5 mx-lg-4 pb-3">
							<p>
								<?php echo esc_html(get_post_meta(get_the_ID(),'meta-blog-para',true)); ?>
							</p>
							
						</div>
						<div class="row single-page-metaimage">
							<div class="col-lg-6 col-md-6 col-sm-6">
								<?php if(get_post_meta($post->ID,'meta-image1',true)) { ?>
				                  <img src="<?php echo esc_html(get_post_meta($post->ID,'meta-image1',true)); ?>" alt="Single Blog Image" class="ps-sm-3 ps-0 mt-sm-0 mt-3">
				                <?php } ?>
							</div>
							<div class="col-lg-6 col-md-6 col-sm-6">
								<?php if(get_post_meta($post->ID,'meta-image2',true)) { ?>
				                  <img src="<?php echo esc_html(get_post_meta($post->ID,'meta-image2',true)); ?>" alt="Single Blog Image" class="ps-sm-3 ps-0 mt-sm-0 mt-3">
				                <?php } ?>
							</div>

						</div>
						
							<div class="single-post-content px-xl-5 px-lg-4 mx-xl-5 mx-lg-4 pt-4 mt-3">
								<p>
									<?php echo esc_html(get_post_meta(get_the_ID(),'meta-blog-text',true)); ?>
								</p>
								
							</div>

						<div class="px-xl-5 px-lg-4 mx-xl-5 mx-lg-4">
							<div class="single-post-social-box row">
								<div class="col-lg-8 col-md-12 col-sm-12 mt-1">
									<?php wp_list_categories('exclude=&title_li='); ?>
								</div>
								<div class="post_share col-lg-4 col-md-12 col-sm-12 mt-lg-4 mt-md-4 mt-sm-4 mt-4">
									<?php if ( get_theme_mod('vw_black_and_white_pro_general_settings_post_share',true) ) {
											if ( function_exists('vw_black_and_white_pro_social_share') ) {
												vw_black_and_white_pro_social_share();
											}
					                } ?>
					        	</div>
							</div>	
							<hr>
						</div>
						
			            <div class="clearfix"></div> 
						<div class="single-post-nav px-xl-5 px-lg-4 mx-xl-5 mx-lg-4">
							<?php the_post_navigation( array(
							'next_text' => '<span class="meta-nav" aria-hidden="true">' . __( get_theme_mod('vw_black_and_white_pro_blog_category_next_title'), 'vw-black-and-white-pro' ) . '<i class="fa fa-chevron-right ps-2" aria-hidden="true"></i></span> ' .
								'<span class="screen-reader-text">' . __( 'Next post:', 'vw-black-and-white-pro' ) . '</span> ' .
								'<span class="post-title">%title</span>',
							'prev_text' => '<span class="meta-nav" aria-hidden="true"><i class="fa fa-chevron-left pe-2" aria-hidden="true"></i>' . __( get_theme_mod('vw_black_and_white_pro_blog_category_prev_title'), 'vw-black-and-white-pro' ) . '</span> ' .
								'<span class="screen-reader-text">' . __( 'Previous post:', 'vw-black-and-white-pro' ) . '</span> ' .
								'<span class="post-title">%title</span>',
							) ); ?>
						</div>

						<div class="single-post-comment mx-auto p-4">
							<?php 
								if ( comments_open() || '0' != get_comments_number() ) {
			                    	comments_template();
			                	}
							?>
						</div>
					</div>
				</article>
			<?php 
			endwhile; // end of the loop. ?>
		</div>
		</div>
		<div class="clearfix"></div>
	</div>
</div>
<?php get_footer(); ?>