<?php
/**
 * The Template for displaying all single testimonials.
 *
 * @package vw-black-and-white-pro
 */
get_header();
get_template_part('template-parts/banner');
?>
<div class="container mt-5">
    <?php if (defined('VWBC_VERSION')){
        echo do_shortcode( '[vw-breadcrumb]' );
    } ?>
    <div id="vw-single-testimonial">
        <div class="row">
            <?php while ( have_posts() ) : the_post(); ?>
                <div class="col-md-7 col-sm-12 col-lg-8 col-xs-12">
                    <div class="row">
                    <div class="textimonial-img">
                     <?php if(has_post_thumbnail()){
                                 the_post_thumbnail();
                              } else {?>
                              <i class=" <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_testimonial_client_icon')); ?>"> </i>
                           <?php }?>
                    </div>
                  
                    <h4 class="testimonial_name mt-3">
                        <a href="<?php the_permalink(); ?>" class="vw-team-link">
                      <?php the_title(); ?></a> </h4>
                    <p class=""><?php echo esc_html(get_post_meta($post->ID,'vw_black_and_white_pro_posttype_testimonial_desigstory',true)); ?></p>
                
                </div>
                <div class="single-page-content w-50">
                    <?php the_content();?></div>
                <div class="single-post-social-box row mb-5">
                    <div class="post_share mt-lg-4 mt-md-4 mt-sm-4 mt-4">
                        <?php if ( get_theme_mod('vw_black_and_white_pro_general_settings_post_share',true) ) {
                                if ( function_exists('vw_black_and_white_pro_social_share') ) {
                                                vw_black_and_white_pro_social_share();
                                    }
                            } ?>
                    </div>
                 </div>
               
               
                    <?php // If comments are open or we have at least one comment, load up the comment template
                if ( comments_open() || '0' != get_comments_number() ) {
                    comments_template();
                } ?>
                <?php if(get_theme_mod('vw_black_and_white_pro_related_posts',true)==1){ ?>
                <div class="related-post-wrapper">
                <?php if(get_theme_mod('vw_black_and_white_pro_related_posts_title')!=''){ ?>
                    <h3>
                        <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_related_posts_title')); ?>
                    </h3>
                <?php } ?>
                <div class="row">
                    <?php
                      $current_post_title=get_the_ID();
                      $args = array(
                        'post_type' => 'post',
                        'post_status' => 'publish',
                        'posts_per_page' => get_theme_mod('vw_black_and_white_pro_related_post_count')
                      );  
                      $query = new WP_Query($args); 
                      if ( $query->have_posts() ) :  while ($query->have_posts()) : $query->the_post();

                       if(get_the_ID()!=$current_post_title){

                    ?>
                        <div class="col-lg-4 col-md-4 related-post-wrap mb-4">
                            <?php
                            if(has_post_thumbnail()){
                              the_post_thumbnail(); 
                            }
                            ?>
                            <a href="<?php the_permalink(); ?>" class="post-page-title pt-2"><?php the_title(); ?></a>
                            <div class="post-single-text"><?php $excerpt = get_the_excerpt(); echo esc_html(vw_black_and_white_pro_string_limit_words($excerpt,15)); ?></div>
                        </div>
                    <?php } endwhile; endif; ?>
                </div>
            </div>
            <?php } ?>
                <div class="clearfix"></div>
        
        
        </div>
        <?php if(get_theme_mod('vw_black_and_white_pro_post_general_settings_post_sidebar',true)=='1'){ ?>
        <div class="col-md-5 col-sm-12 col-lg-4 col-xs-12" id="vw-sidebar">
                  <?php dynamic_sidebar('sidebar-1'); ?>
                </div>
            <?php } endwhile;  // end of the loop. ?>
        </div>
    </div>
    <div class="clearfix"></div>
</div>
<?php get_footer(); ?>