<?php
   /**
    * vw-black-and-white-pro functions and definitions
    *
    * @package vw-black-and-white-pro
    */

   if ( ! function_exists( 'vw_black_and_white_pro_setup' ) ) :
   /**
    * Sets up theme defaults and registers support for various WordPress features.
    *
    * Note that this function is hooked into the after_setup_theme hook, which runs
    * before the init hook. The init hook is too late for some features, such as indicating
    * support post thumbnails.
    */
   function vw_black_and_white_pro_setup() {
     $GLOBALS['content_width'] = apply_filters( 'vw_black_and_white_pro_content_width', 640 );
     if ( ! isset( $content_width ) ) $content_width = 640;
     load_theme_textdomain( 'vw-black-and-white-pro', get_template_directory() . '/languages' );
     add_theme_support( 'automatic-feed-links' );
     add_theme_support( 'post-thumbnails' );
     add_theme_support( 'woocommerce' );
     add_theme_support( 'custom-header' );
     add_theme_support( 'title-tag' );
     add_theme_support( 'wc-product-gallery-zoom' );
     add_theme_support( 'wc-product-gallery-lightbox' );
     add_theme_support( 'wc-product-gallery-slider' );

     add_theme_support( 'custom-logo', array(
       'height'      => 240,
       'width'       => 240,
       'flex-height' => true,
     ) );

  add_image_size('vw-black-and-white-pro-homepage-thumb',240,145,true);
     register_nav_menus( array(
       'primary'   => __( 'Primary Menu', 'vw-black-and-white-pro' ),
     ) );
     register_nav_menus( array(
       'footer'   => __( 'Links', 'vw-black-and-white-pro' ),
     ) );
      register_nav_menus( array(
       'footer1'   => __( 'Categories', 'vw-black-and-white-pro' ),
     ) );
      register_nav_menus( array(
       'footer2'   => __( 'services', 'vw-black-and-white-pro' ),
     ) );


     add_theme_support( 'custom-background', array(
       'default-color' => 'f1f1f1'
     ) );
     add_editor_style();
   }
   endif;
   add_action( 'after_setup_theme', 'vw_black_and_white_pro_setup' );



   /* Theme enqueue scripts */
   function vw_black_and_white_pro_scripts() {
     wp_enqueue_style( 'vw-black-and-white-pro-font', vw_black_and_white_pro_font_url(), array() );
     wp_enqueue_style( 'vw-black-and-white-pro-basic-style', get_stylesheet_uri() );
     wp_style_add_data( 'vw-black-and-white-pro-style', 'rtl', 'replace' );

     /* Inline style sheet */
     require get_parent_theme_file_path( '/inline_style.php' );
     wp_add_inline_style( 'vw-black-and-white-pro-basic-style',$custom_css );

     if(is_rtl()){
       wp_enqueue_style( 'rtl-style', get_template_directory_uri().'/rtl.css',true, null,'all');
       wp_add_inline_style( 'rtl-style',$custom_css );
     }else{
       // ---------- CSS Enqueue -----------
    if(is_front_page() || is_home()){
         wp_enqueue_style( 'home-page-style', get_template_directory_uri().'/assets/css/main-css/home-page.css',true, null,'all');
         wp_add_inline_style( 'home-page-style',$custom_css );


         }
         else{
          wp_enqueue_style( 'other-page-style', get_template_directory_uri() . '/assets/css/main-css/other-pages.css',true, null,'all');
         wp_add_inline_style( 'other-page-style',$custom_css );
         }

       wp_enqueue_style( 'header-footer-style', get_template_directory_uri().'/assets/css/main-css/header-footer.css',true, null,'all' );
       wp_enqueue_style( 'responsive-style', get_template_directory_uri().'/assets/css/main-css/mobile-main.css',true, null,'screen and (max-width: 3000px) and (min-width: 0px)' );

       wp_add_inline_style( 'header-footer-style',$custom_css );
       wp_add_inline_style( 'responsive-media-style',$custom_css );

   if ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ) {
       wp_enqueue_style( 'amp-style', get_template_directory_uri().'/assets/css/main-css/amp-style.css',true, null,'all' );
       wp_enqueue_script( 'amp-sidebar', get_template_directory_uri() . '/assets/js/amp-sidebar-0.1.js', array('jquery'), '',true);
     }
     else{
     // ---------- CSS Enqueue -----------

     wp_enqueue_style( 'vw-custom_controls_css',get_template_directory_uri().'/assets/css/customizer.css');
     wp_enqueue_style( 'animation-wow',get_template_directory_uri().'/assets/css/animate.css' );
     wp_enqueue_style( 'aos',get_template_directory_uri().'/assets/css/aos.css' );
     wp_enqueue_style( 'animation',get_template_directory_uri().'/assets/css/animation.css' );
   }
     wp_enqueue_style( 'custom-animation', get_template_directory_uri().'/assets/css/custom-animation.css' );
     wp_enqueue_style( 'effect', get_template_directory_uri().'/assets/css/effect.css' );
   }
     wp_enqueue_style( 'owl-carousel-style', get_template_directory_uri().'/assets/css/owl.carousel.css' );
     wp_enqueue_style( 'font-awesome',get_template_directory_uri().'/assets/css/fontawesome-all.min.css' );
     // wp_enqueue_style( 'google-font',get_template_directory_uri().'/assets/css/google-font.css' );
     wp_enqueue_style( 'basic-font', get_template_directory_uri().'/assets/css/basicfont.css' );
     wp_enqueue_style( 'bootstrap-style', get_template_directory_uri().'/assets/css/bootstrap.min.css' );
     wp_enqueue_style( 'video-popup', get_template_directory_uri().'/assets/css/video.popup.css' );
     wp_enqueue_style( 'vw-black-and-white-pro', get_template_directory_uri().'/assets/css/vw-black-and-white-pro.css' );

   // ---------- JS Enqueue -----------
     wp_enqueue_script( 'animation-wow', get_template_directory_uri() . '/assets/js/wow.min.js', array( 'jquery' ) );

     wp_enqueue_script( 'animation-aos', get_template_directory_uri() . '/assets/js/aos.js', array( 'jquery' ) );
     wp_enqueue_script( 'tether', get_template_directory_uri() . '/assets/js/tether.js', array( 'jquery' ) );
     wp_enqueue_script( 'amp-sidebar', get_theme_file_uri( '/assets/js/amp-sidebar-0.1.js' ), array( 'jquery' ), true );
     wp_enqueue_script( 'superfish', get_template_directory_uri() . '/assets/js/jquery.superfish.js', array( 'jquery' ) );
     wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.js', array( 'jquery' ) );
     wp_enqueue_script( 'smooth-scroll', get_template_directory_uri() . '/assets/js/SmoothScroll.js', array( 'jquery' ) );
     wp_enqueue_script( 'video-popup', get_template_directory_uri() . '/assets/js/video.popup.js', array( 'jquery' ) );
     wp_enqueue_script( 'jquery-progressbar-js', get_template_directory_uri() . '/assets/js/jquery-progressbar.js', array( 'jquery' ) );

  //    wp_register_script( 'vw-black-and-white-pro-customscripts', get_template_directory_uri() . '/assets/js/custom.js', array('jquery', 'owl-carousel') );
	// $vw_black_and_white_pro_api_object = array(
	// 	'root'					=>	rest_url(),
	// 	'ajaxurl'				=>	admin_url('admin-ajax.php'),
	// 	'nonce'					=>	wp_create_nonce( 'wp_rest' ),
	// 	'the_rest_url'	=>	get_rest_url(),
  //   'is_rtl' => is_rtl()
	// );
	// wp_localize_script( 'vw-black-and-white-pro-customscripts', 'vw_black_and_white_pro_api_object', $vw_black_and_white_pro_api_object );
	// wp_enqueue_script( 'vw-black-and-white-pro-customscripts' );


  wp_register_script('vw-black-and-white-pro-customscripts', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'),'', true);

  wp_localize_script(
    'vw-black-and-white-pro-customscripts',
    'vw_black_and_white_pro_api_object',
    array(
      'is_rtl' => is_rtl()
    )
  );
  wp_enqueue_script( 'vw-black-and-white-pro-customscripts' );



     wp_enqueue_script( 'jquery-ui.min', get_template_directory_uri() . '/assets/js/jquery-ui.min.js', array( 'jquery' ) );
     wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array( 'jquery' ) );
     wp_enqueue_script( 'jquery-appear', get_template_directory_uri() . '/assets/js/jquery.appear.js', array( 'jquery' ) );

   }
   add_action( 'wp_enqueue_scripts', 'vw_black_and_white_pro_scripts' );

   /* Implement the Custom Header feature. */
   require get_parent_theme_file_path('/inc/custom-header.php' );
   /* Custom template tags for this theme. */
   require get_parent_theme_file_path('/inc/template-tags.php' );
   require get_template_directory().'/inc/verify_theme_version.php';
   /* Customizer additions. */
   require get_parent_theme_file_path('/inc/customize/customizer.php' );
   require get_template_directory() . '/theme-wizard/config.php';
   require get_parent_theme_file_path('/theme-wizard/plugin-activation.php' );
   /* Widget Sidebar */
   require get_parent_theme_file_path('/inc/widget-sidebar.php' );
   /* Google Fonts */
   require get_parent_theme_file_path('/inc/google-fonts.php' );
   //social widget file
   require get_parent_theme_file_path('/inc/widget/socail-widget.php' );
   //Contact Widget file
   require get_parent_theme_file_path('/inc/widget/contact-widget.php' );


   /* URL DEFINES */
   define('vw_black_and_white_pro_SITE_URL','https://www.vwthemes.com/');
   /* Theme Credit link */
   function vw_black_and_white_pro_credit_link() {
    echo esc_html_e(' Design & Developed by','vw-black-and-white-pro'). "<a href=".esc_url(vw_black_and_white_pro_SITE_URL)." target='_blank'> VW Themes</a>";
   }
   /*Radio Button sanitization*/
   function vw_black_and_white_pro_sanitize_choices( $input, $setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $setting->id );
    if ( array_key_exists( $input, $control->choices ) ) {
      return $input;
    } else {
      return $setting->default;
    }
   }

     /* Breadcrumb Begin */
   function vw_black_and_white_pro_the_breadcrumb() {
    if (!is_home()) {
      echo '<a href="';
        echo esc_url(home_url());
      echo '">';
       echo ' Home ';
      echo "</a> ";
      if (is_category() || is_single()) {
        the_category(', ');
        if (is_single()) {
          echo " > <span> ";
            the_title();
          echo "</span> ";
        }
      } elseif (is_page()) {
        echo " > <span> ";
          the_title();
        echo "</span> ";
      }
    }
   }

   /*
* Show post Share
*/
if ( !function_exists('vw_black_and_white_pro_social_share') ) {
    /**
     * [vw_black_and_white_pro_social_share show all the social share buttons
     * @return [type] string
     */
    function vw_black_and_white_pro_social_share(){
        ?>
        <?php do_action('vw_black_and_white_pro_before_blog_sharing'); ?>
            <div class="share_icon row p-0 m-0 text-center">
                <p class="socila_share col-md-12 p-0 mb-0">
                    <?php if(get_theme_mod('vw_black_and_white_pro_general_settings_post_share_facebook',true)==1 || get_theme_mod('vw_black_and_white_pro_general_settings_post_copy',true)==1 || get_theme_mod('vw_black_and_white_pro_general_settings_post_share_twitter',true)==1){ ?>


                    <?php }

                    if ( get_theme_mod('vw_black_and_white_pro_general_settings_post_share_facebook',true) == "1" ) { ?>
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo the_permalink(); ?>" target="_blank" class="me-2"><i class="fab fa-facebook-f"></i><span class="screen-reader-text"><?php echo esc_html('facebook.com', 'vw-black-and-white-pro' ) ; ?></span></a>
                    <?php }



                    if ( get_theme_mod('vw_black_and_white_pro_general_settings_post_share_twitter',true) == "1" ) { ?>
                        <a href="https://twitter.com/share?url=<?php the_permalink(); ?>&amp;text=<?php echo the_title(); ?>" target="_blank" class="me-2"><i class="fab fa-twitter"></i><span class="screen-reader-text"><?php echo esc_html('twitter.com', 'vw-black-and-white-pro' ) ; ?></span></a>
                    <?php }

                    ?>

                </p>
            </div>
        <?php
    }
}

   function k99_relative_time() {
    $post_date = get_the_time('U');
    $delta = time() - $post_date;
    if ($delta > 60 && $delta < 120){
        echo 'few minute ago';
    }
    elseif ($delta > 120 && $delta < (60*60)){
        echo strval(round(($delta/60),0)), ' minutes ago';
    }
    elseif ($delta > (60*60) && $delta < (120*60)){
        echo 'few hour ago';
    }
    elseif ($delta > (120*60) && $delta < (24*60*60)){
        echo strval(round(($delta/3600),0)), ' hours ago';
    }
    else {
        echo the_time('j\<\s\u\p\>S\<\/\s\u\p\> M y g:i a');
    }
}


   /* Excerpt Limit Begin */
   function vw_black_and_white_pro_string_limit_words($string, $word_limit) {
    $words = explode(' ', $string, ($word_limit + 1));
    if(count($words) > $word_limit)
    array_pop($words);
    return implode(' ', $words);
   }

   /* Excerpt Read more overwrite */
   function vw_black_and_white_pro_excerpt_more( $link ) {
    if ( is_admin() ) {
      return $link;
    }
    $link = sprintf( '<p class="link-more"><a href="%1$s" class="more-link">%2$s</a></p>',
      esc_url( get_permalink( get_the_ID() ) ),
      /* translators: %s: Name of current post */
      sprintf( __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'vw-black-and-white-pro' ), get_the_title( get_the_ID() ) )
    );
    return ' &hellip; ' . $link;
   }
   add_filter( 'excerpt_more', 'vw_black_and_white_pro_excerpt_more' );

   define('vw_black_and_white_pro_THEME_DOC','https://www.vwthemesdemo.com/docs/vw-black-and-white-pro/');
   define('vw_black_and_white_pro_SUPPORT','https://www.vwthemes.com/support/vw-theme/cv-resume-pro/');
   define('vw_black_and_white_pro_FAQ','https://www.vwthemes.com/faqs/');
   define('vw_black_and_white_pro_CONTACT','https://www.vwthemes.com/contact/');
   define('vw_black_and_white_pro_REVIEW','https://www.vwthemes.com/topic/reviews-and-testimonials/');
   define('vw_black_and_white_pro_SHOPIFY','https://www.vwthemes.com/premium-shopify/vw-showcase-shopify-theme/');
   define('vw_black_and_white_pro_MOODLE','https://vwthemes.com/lms-themes/taleem-responsive-moodle-theme/');
   define('vw_black_and_white_pro_MOBILE_APP','https://www.vwthemes.com/premium-plugin/vw-woocommerce-mobile-app/');
   define('vw_black_and_white_pro_DEMO_IMPORTER','https://www.youtube.com/watch?v=pCeJwmd-5sM&feature=youtu.be');
   define( 'IBTANA_THEME_LICENCE_ENDPOINT', 'https://vwthemes.com/wp-json/ibtana-licence/v2/' );



   /*===================================================================================
   * Add Author Links
   * =================================================================================*/
function vw_black_and_white_pro_home_call_button(){
  if(get_theme_mod('vw_black_and_white_pro_contactpage_phone_contact_options') == 'Call' ) {
    return true;
  }
  return false;
}
function vw_black_and_white_pro_home_whatsapp_call_button(){
  if(get_theme_mod('vw_black_and_white_pro_contactpage_phone_contact_options') == 'Whatsapp' ) {
    return true;
  }
  return false;
}

function vw_black_and_white_pro_home_call_button1(){
  if(get_theme_mod('vw_black_and_white_pro_about_page_section1_about_page_options') == 'Call' ) {
    return true;
  }
  return false;
}
function vw_black_and_white_pro_home_whatsapp_call_button1(){
  if(get_theme_mod('vw_black_and_white_pro_about_page_section1_about_page_options') == 'Whatsapp' ) {
    return true;
  }
  return false;
}
   function add_to_author_profile( $contactmethods ) {

     $contactmethods['tumbler_url'] = 'Tumbler URL';
     $contactmethods['pinterest_profile'] = 'Pinterest Profile URL';
     $contactmethods['twitter_profile'] = 'Twitter Profile URL';
     $contactmethods['facebook_profile'] = 'Facebook Profile URL';

     return $contactmethods;
   }
   add_filter( 'user_contactmethods', 'add_to_author_profile', 10, 1);
   Class My_Recent_Posts_Widget extends WP_Widget_Recent_Posts {
      function widget($args, $instance) {
              if ( ! isset( $args['widget_id'] ) ) {
              $args['widget_id'] = $this->id;
          }
          $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts', 'vw-black-and-white-pro' );
          /** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
          $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
          $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
          if ( ! $number )
              $number = 5;
          $show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;
          /**
           * Filter the arguments for the Recent Posts widget.
           *
           * @since 3.4.0
           *
           * @see WP_Query::get_posts()
           *
           * @param array $args An array of arguments used to retrieve the recent posts.
           */
          $r = new WP_Query( apply_filters( 'widget_posts_args', array(
              'posts_per_page'      => $number,
              'no_found_rows'       => true,
              'post_status'         => 'publish',
              'ignore_sticky_posts' => true
          ) ) );
          if ($r->have_posts()) :
          ?>
<?php echo $args['before_widget']; ?>
<?php if ( $title ) {
   echo $args['before_title'] . esc_html($title) . $args['after_title'];
   } ?>
<ul>
   <?php while ( $r->have_posts() ) : $r->the_post(); ?>
   <li>
      <div class="row recent-post-box">
         <div class="post-thumb <?php if(has_post_thumbnail()) { echo 'col-lg-5 col-md-4 col-sm-4 col-12'; } ?> ">
            <?php the_post_thumbnail(); ?>
         </div>
         <div class="post-content pt-3 <?php if(has_post_thumbnail()) { echo ' col-lg-7 col-md-8 col-sm-8 col-12'; } else { echo 'col-lg-12 col-md-12 col-sm-12 col-12'; }?>">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            <?php if ( $show_date ) : ?>
            <p class="post-date"><?php the_date(); ?></p>
            <?php endif; ?>
         </div>
      </div>
   </li>
   <?php endwhile;
      wp_reset_postdata(); ?>
</ul>
<?php echo $args['after_widget'];
   endif;
   }
   }
   function gt_get_post_view() {
    $count = get_post_meta( get_the_ID(), 'post_views_count', true );
    return "$count views";
    print_r($count);
    exit;
    }
    function gt_set_post_view() {
        $key = 'post_views_count';
        $post_id = get_the_ID();
        $count = (int) get_post_meta( $post_id, $key, true );
        $count++;
        update_post_meta( $post_id, $key, $count );
    }
    function gt_posts_column_views( $columns ) {
        $columns['post_views'] = 'Views';
        return $columns;
    }
    function gt_posts_custom_column_views( $column ) {
        if ( $column === 'post_views') {
            echo gt_get_post_view();
        }
  }
add_filter( 'manage_posts_columns', 'gt_posts_column_views' );
add_action( 'manage_posts_custom_column', 'gt_posts_custom_column_views' );
add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );

remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
add_action('et_after_shop_loop_title', 'get_star_rating' );
function get_star_rating()
{
    global $woocommerce, $product;
    $average = $product->get_average_rating();

    echo '<div class="star-rating"><span style="width:'.( ( $average / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">'.$average.'</strong> '.__( 'out of 5', 'woocommerce' ).'</span></div>';
}

// --------user---------

add_action('init', 'ehi_add_author_woocommerce', 999 );
function ehi_add_author_woocommerce()
{
    if (post_type_exists('product'))
    {
        add_post_type_support('product', 'author');
    }
}

add_filter('loop_shop_columns', 'loop_columns', 999);
if (!function_exists('loop_columns')) {
  function loop_columns() {
    return 3; // 3 products per row
  }
}

function remove_featured_category_from_frontend(array $terms)
{
    if ( ! is_admin() && !is_home() && is_front_page() ){
        $terms = array_filter($terms, function ($term) {
            if ($term->taxonomy === 'product_cat') {
                return $term->slug !== 'uncategorized';
            }
            return true;
        });
    }
    return $terms;
}
add_filter('get_terms', 'remove_featured_category_from_frontend');
add_filter('get_object_terms', 'remove_featured_category_from_frontend');

add_action( 'admin_enqueue_scripts', function( $hook ) {
  if ( 'user-edit.php' == $hook ) {
    wp_enqueue_script(
      'vw_black_and_white_pro_user_profile_upload_script',
      get_template_directory_uri() . '/assets/js/user-profile.js',
      array('jquery'),
      '',
      true
    );
  }
} );
function my_recent_widget_registration() {
   unregister_widget('WP_Widget_Recent_Posts');
   register_widget('My_Recent_Posts_Widget');
   }
   add_action('widgets_init', 'my_recent_widget_registration');

   function add_form_settings() {
   ?>
New 1: <input id="new_setting" name="new_settings" type="text" />
New 2: <input id="new_setting2" name="new_setting2" type="text" />
<?php
}
add_action( 'myplugin_after_form_settings', 'add_form_settings' );
add_action('switch_theme', 'vw_black_and_white_pro_deactivate');
function vw_black_and_white_pro_deactivate() {
  ThemeWhizzie::remove_the_theme_key();
  ThemeWhizzie::set_the_validation_status('false');
}

define('CUSTOM_TEXT_DOMAIN', 'affiliate-review');

 /* ------------------ News post -------------- */
function vw_black_and_white_pro_posttype_images_news_metabox_enqueue($hook) {
  if ( 'post.php' === $hook || 'post-new.php' === $hook ) {
    wp_enqueue_script('vw-black-and-white-pro-images-news-metabox', plugin_dir_url( __FILE__ ) . '/js/img-metabox.js', array('jquery', 'jquery-ui-sortable'));

    global $post;
    if ( $post ) {
      wp_enqueue_media( array(
          'post' => $post->ID,
        )
      );
    }
  }
}
add_action('admin_enqueue_scripts', 'vw_black_and_white_pro_posttype_images_news_metabox_enqueue');
/* Hook things in for admin*/
if (is_admin()){
  add_action('admin_menu', 'vw_black_and_white_pro_posttype_bn_custom_meta_news');
}

function vw_black_and_white_pro_posttype_bn_custom_meta_news() {

    add_meta_box( 'bn_meta', __( 'News Meta', 'vw-black-and-white-pro-posttype' ), 'vw_black_and_white_pro_posttype_bn_meta_callback_news', 'post', 'normal', 'high' );
}

function vw_black_and_white_pro_posttype_bn_meta_callback_news( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'bn_nonce' );
    $bn_stored_meta = get_post_meta( $post->ID );
    $meta_blog_question = get_post_meta( $post->ID, 'meta-blog-que', true );
    $meta_blog_para = get_post_meta( $post->ID, 'meta-blog-para', true );
    $meta_blog_text = get_post_meta( $post->ID, 'meta-blog-text', true );

    $single_img1 = get_post_meta($post->ID,'meta-image1',true);
    $single_img2 = get_post_meta($post->ID,'meta-image2',true);
    $meta_banner_image = get_post_meta($post->ID,'meta-single-banner',true);

?>
  <div id="property_stuff">
    <table id="list-table">
      <tbody id="the-list" data-wp-lists="list:meta">
        <tr id="meta-1">
          <td class="left">
            <?php esc_html_e( 'Blog Title', 'vw-black-and-white-pro-posttype' )?>
          </td>
          <td class="left" >
            <input type="text" name="meta-blog-que" id="meta-blog-que" value="<?php echo esc_html($meta_blog_question); ?>" />
          </td>
        </tr>
        <tr>
          <td class="left">
            <?php esc_html_e( 'Blog Paragraph 1', 'vw-black-and-white-pro-posttype' )?>
          </td>
          <td class="left" >
            <input name="meta-blog-para" id="meta-blog-para" value="<?php echo esc_html($meta_blog_para); ?>" />
          </td>
        </tr>
        <tr id="meta-1">
          <td class="left">
            <?php esc_html_e( 'Blog Paragraph 2', 'vw-black-and-white-pro-posttype' )?>
          </td>
          <td class="left" >
            <input name="meta-blog-text" id="meta-blog-text" value="<?php echo esc_html($meta_blog_text); ?>" />
          </td>
        </tr>
        <tr>
          <td>Banner Image</td>
          <td>
              <input type="text" name="meta-single-banner" id="meta-single-banner" class="meta-image regular-text" value="<?php echo esc_html($meta_banner_image); ?>">
              <input type="button" class="button image-upload" value="Browse">
          </td>
        </tr>
        <tr>
          <td>Single Image 1</td>
          <td>
              <input type="text" name="meta-image1" id="meta-image1" class="meta-image regular-text" value="<?php echo esc_html($single_img1); ?>">
              <input type="button" class="button image-upload" value="Browse">
          </td>
        </tr>
        <tr>
          <td>Single Image 2</td>
          <td>
              <input type="text" name="meta-image2" id="meta-image2" class="meta-image regular-text" value="<?php echo esc_html($single_img2); ?>">
              <input type="button" class="button image-upload" value="Browse">
          </td>
        </tr>
      </tbody>
    </table>
  </div>
  <?php
}

function vw_black_and_white_pro_posttype_bn_meta_save_news( $post_id ) {

  if (!isset($_POST['bn_nonce']) || !wp_verify_nonce($_POST['bn_nonce'], basename(__FILE__))) {
    return;
  }

  if (!current_user_can('edit_post', $post_id)) {
    return;
  }

  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    return;
  }

  // Team Meta 1
  if( isset( $_POST[ 'meta-blog-que' ] ) ) {
      update_post_meta( $post_id, 'meta-blog-que', sanitize_text_field($_POST[ 'meta-blog-que' ]) );
  }

  if( isset( $_POST[ 'meta-blog-para' ] ) ) {
      update_post_meta( $post_id, 'meta-blog-para', sanitize_text_field($_POST[ 'meta-blog-para' ]) );
  }

  // Team Meta 2
  if( isset( $_POST[ 'meta-blog-text' ] ) ) {
      update_post_meta( $post_id, 'meta-blog-text', sanitize_text_field($_POST[ 'meta-blog-text' ]) );
  }


  if( isset( $_POST[ 'meta-image1' ] ) ) {
      update_post_meta( $post_id, 'meta-image1', esc_url_raw($_POST[ 'meta-image1' ]) );
  }
  if( isset( $_POST[ 'meta-image2' ] ) ) {
      update_post_meta( $post_id, 'meta-image2', esc_url_raw($_POST[ 'meta-image2' ]) );
  }
  if( isset( $_POST[ 'meta-single-banner' ] ) ) {
      update_post_meta( $post_id, 'meta-single-banner', esc_url_raw($_POST[ 'meta-single-banner' ]) );
  }

  if( isset( $_POST[ 'meta-url' ] ) ) {
      update_post_meta( $post_id, 'meta-url', esc_url_raw($_POST[ 'meta-url' ]) );
  }


}
add_action( 'save_post', 'vw_black_and_white_pro_posttype_bn_meta_save_news' );

function vw_black_and_white_pro_single_testi_category($single_template) {
  global $post;
  if ($post->post_type == 'testimonials') {
    $single_template = dirname( __FILE__ ) . '/single-testimonials.php';
  }
  return $single_template;
}
add_filter( 'single_template', 'vw_black_and_white_pro_single_testi_category' );
/*----------------------- News Shortcode ------------------------------*/
function vw_black_and_white_pro_posttype_news_func( $atts ) {
  $custom_url ='';
  $post_id = get_the_ID();
  $team = '';
  $eventname='';
  $eventcount='';
  $ratingname='';
  $ratingcount='';
  $meetzone='';
  $team = '<div id="accordion" class="row">';
  $query = new WP_Query( array( 'post_type' => 'zoom_meeting') );
  if(get_post_meta($post_id,'meta-meeting-information-url',true !='')){$custom_url =get_post_meta($post_id,'meta-meeting-information-url',true); } else{ $custom_url = get_permalink(); }
    if ( $query->have_posts() ) :

  $k=1;
  $new = new WP_Query('post_type=zoom_meeting');

  while ($new->have_posts()) : $new->the_post();
        $post_id = get_the_ID();
        $excerpt = wp_trim_words(get_the_excerpt(),25);

        $eventname = get_post_meta($post_id,'meta-event-name',true);
        $eventcount = get_post_meta($post_id,'meta-event-count',true);
        $ratingname =get_post_meta($post_id,'meta-rating-name',true);
        $ratingcount = get_post_meta($post_id,'meta-rating-count',true);

        $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post_id), 'large' );
        if(has_post_thumbnail()) { $thumb_url = $thumb['0']; }
        $team .= '<div class="col-lg-3 col-md-6 col-sm-12 col-12">
                              <div class="row wow zoomInUp delay-1000 animated" data-wow-duration="2s">
                                <div class="col-lg-8 col-md-8 col-sm-8 col-12 text-lg-start text-md-start text-sm-start text-center">
                                  <h4><a href="'.get_the_permalink().'">'.esc_html(get_the_title()) .'</a></h4>
                                  <div class="events_icon row">
                                    <div class="col-lg-5 col-md-6 pr-0"><img src="'.esc_url($thumb_url).'"></div>
                                    <div class="col-lg-7 col-md-6 pl-0">
                                      <p class="event-date">
                                        Event Date : '.$meetdate.'
                                      </p>
                                    </div>
                                </div>
                              </div>
                        </div>
        </div>';
    if($k%2 == 0){
      $team.= '<div class="clearfix"></div>';
    }
      $k++;
  endwhile;
  else :
    $team = '<h2 class="center">'.esc_html__('Post Not Found','vw-black-and-white-pro-posttype').'</h2>';
  endif;
  $team .= '</div>';
  return $team;
}
add_shortcode( 'vw-black-and-white-pro-news', 'vw_black_and_white_pro_posttype_news_func' );



add_filter('post_link', 'track_displayed_posts');
add_action('pre_get_posts','remove_already_displayed_posts');

$displayed_posts = [];

function track_displayed_posts($url) {
  global $displayed_posts;
  $displayed_posts[] = get_the_ID();
  return $url; // don't mess with the url
}

function remove_already_displayed_posts($query) {
 global $displayed_posts;
 $query->set('post__not_in', $displayed_posts);
}

// --------------------------login shortcode-----------------
add_action( 'login_form_middle', 'add_lost_password_link' );
function add_lost_password_link() {
    return '<a href="/wp-login.php?action=lostpassword">Forgot Your Password?</a>';
}

if(!function_exists('vivid_login_page'))
{
  function vivid_login_page()
  {
      $args = array(
        'echo'           => true,
        'remember'       => true,
        'redirect'       => ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'],
        'form_id'        => 'loginform',
        'id_username'    => 'user_login',
        'id_password'    => 'user_pass',
        'id_remember'    => 'rememberme',
        'id_submit'      => 'wp-submit',
        'label_username' => __( 'Username or Email Address' ),
        'label_password' => __( 'Password' ),
        'label_remember' => __( 'Remember Me' ),
        'label_log_in'   => __( 'Log In' ),
        'value_username' => '',
        'value_remember' => false
    );
    wp_login_form($args);
    add_lost_password_link();
  }
  add_shortcode('vivid-login-page', 'vivid_login_page');
}
