jQuery(document).ready(function($) {
    'use strict';
    var this_obj = vw_black_and_white_pro_activate_plugin;

    $(document).on('click', '.vw-theme-plugin-install', function(event) {
        
        event.preventDefault();
        var button = $(this);
        var slug = button.data('slug');
        button.text(this_obj.installing + '...').addClass('updating-message');
        wp.updates.installPlugin({
            slug: slug,
            success: function(data) {
                button.attr('href', data.activateUrl);
                button.text(this_obj.activating + '...');
                button.removeClass('button-secondary updating-message vw-theme-plugin-install');
                button.addClass('button-primary vw-theme-plugin-activate');
                button.trigger('click');
            },
            error: function(data) {
                jQuery('.vw-theme-recommended-plugins .vw-theme-activation-note').css('display','block');
                //console.log('error', data);
                button.removeClass('updating-message');
                button.text(this_obj.error);
            },
        });

    });

    $(document).on('click', '.vw-theme-plugin-activate', function(event) {
        var redirect_class = jQuery(this).attr('class');
        event.preventDefault();
        var button = $(this);
        var url = button.attr('href');
        if (typeof url !== 'undefined') {
            // Request plugin activation.
            jQuery.ajax({
                async: true,
                type: 'GET',
                url: url,
                beforeSend: function() {
                    button.text(this_obj.activating + '...');
                    button.removeClass('button-secondary');
                    button.addClass('button-primary activate-now updating-message');
                },
                success: function(data) {
                    if(redirect_class.indexOf('ive-redirect-to-dashboard') != -1){
                        location.href = this_obj.ibtana_admin_url;
                    }else{
                        location.reload();
                    }
                }
            });
        }
    });

});
