<?php 
   /**
    * Template part for displaying feature Skill
    *
    * @package vw-black-and-white-pro
    */ 
   
   $section_hide = get_theme_mod( 'vw_black_and_white_pro_feature_skill_enable' );
   if ( 'Disable' == $section_hide ) {
    return;
   }
 
   if( get_theme_mod('vw_black_and_white_pro_feature_skill_bgcolor','') ) {
    $feature_backg = 'background-color:'.esc_attr(get_theme_mod('vw_black_and_white_pro_feature_skill_bgcolor','')).';';
   }elseif( get_theme_mod('vw_black_and_white_pro_feature_skill_bgimage','') ){
    $feature_backg = 'background-image:url(\''.esc_url(get_theme_mod('vw_black_and_white_pro_feature_skill_bgimage')).'\')';
   }else{
    $feature_backg='';
   }
  
   ?>
<section id="FeatureSkill" style="<?php echo esc_attr($feature_backg); ?>" class="mt-4">
   <div class="container ps-lg-5 pe-lg-5 feature-skil-prog">
      <div class="row br-top-bottom">
         <div class="col-lg-12 text-center mt-5 pt-5 pb-5 feature-skill-mob">
            <h6 class="progress-head">
               <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_feature_skill_small_heading')); ?>
            </h6>
            <h2 class="hvr-underline-from-center py-2">
               <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_feature_skill_main_heading')); ?>
            </h2>
            
         </div>
         <div class="row progress-rws ps-lg-3 ps-sm-5 ps-5">
         <div class="col-lg-5 col-md-6 col-sm-12 col-12 offset-lg-1 col-md-6 left-progressbar">
            <?php
               $feature_skill_count=get_theme_mod('vw_black_and_white_pro_feature_skill_number');
                 for($i=1;$i<=$feature_skill_count;$i++)
                 { ?>
            <div class="col-lg-12 progress-bar-main-div pb-3">
               <div class="row">
                  <div class="col-lg-8 col-md-8 text-center text-sm-center text-md-start text-lg-start progress-bar-text-div col-sm-8 col-8 prog-mob<?php echo($i)?>">
                     <span><img src="<?php echo esc_url(get_theme_mod('vw_black_and_white_pro_progress_bar_icon_image'.$i)); ?>"><p class="progress-bar-text mb-0"><?php echo (get_theme_mod('vw_black_and_white_pro_feature_skill_progress_bar_text'.$i)); ?></p>
                     </span>
                  </div>
                  <div class="col-lg-4 col-md-4 col-sm-4 col-4 text-center text-sm-center text-md-end text-lg-end progress-bar-per-div">
                     <p class="progress-bar-per"><?php echo (get_theme_mod('vw_black_and_white_pro_feature_skill_progress_bar_percentage'.$i)); ?>%</p>
                  </div>
               </div>
               <div class="progress" style="height:3px" >
                  <div class="progress-bar" percent="<?php echo (get_theme_mod('vw_black_and_white_pro_feature_skill_progress_bar_percentage'.$i)); ?>"></div>
               </div>
            </div>
            <?php } ?>
         </div>
         <div class="col-lg-5 col-md-6 col-sm-12 col-12 right-progressbar offset-lg-1">
           <?php
               $feature_skill_counts=get_theme_mod('vw_black_and_white_pro_feature_skill_numbers');
                 for($i=1;$i<=$feature_skill_counts;$i++)
                 { ?>
             <span class="progress-icon-img pb-3"><i class="<?php echo (get_theme_mod('vw_black_and_white_pro_feature_skill_progress_bar_right_icon_img'.$i)); ?>"></i> 
               <h6 class="progress-icon-texts">
               <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_feature_right_heading'.$i)); ?>
                </h6>
              </span>
             <?php } ?>
         </div>
      </div>
      </div>
   </div>
</section>