<?php 
   /**
    * Template part for displaying Our team
    *
    * @package vw-black-and-white-pro
    */ 
   
   $section_hide = get_theme_mod( 'vw_black_and_white_pro_our_team_enable' );
   if ( 'Disable' == $section_hide ) {
    return;
   }
   
   if( get_theme_mod('vw_black_and_white_pro_our_team_bgcolor','') ) {
    $our_team_backg = 'background-color:'.esc_attr(get_theme_mod('vw_black_and_white_pro_our_team_bgcolor','')).';';
   }elseif( get_theme_mod('vw_black_and_white_pro_our_team_bgimage','') ){
    $our_team_backg = 'background-image:url(\''.esc_url(get_theme_mod('vw_black_and_white_pro_our_team_bgimage')).'\')';
   }else{
    $our_team_backg='';
   }
   
   $img_bg = get_theme_mod('vw_black_and_white_pro_our_team_bgimage_setting',true);
   
   ?>
<section id="our-team" style="<?php echo esc_attr($our_team_backg);?>" class="ms-lg-5 ps-lg-5">
   <div class="container">
      <div class="br-top-bottom br-tops">
      <div class="row ps-lg-4 pe-lg-5 ms-lg-4 me-lg-5 our-teams-bxs-mob">
         <div class="col-lg-12">
           <h6 class="">
            <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_our_team_top_heading')); ?>
          </h6>
          <h2 class="mt-2">
         <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_our_team_main_heading')); ?>
        </h2>
        </div>
      </div>
   <div class="our-team-box ps-lg-5 pe-lg-5 ms-lg-3 me-lg-5">
      <div class="owl-carousel mt-5">
         <?php
            $i=1;
            $args = array(
              'post_type' => 'team',
              'post_status' => 'publish',
              'posts_per_page' => get_theme_mod('vw_black_and_white_pro_our_team_number'),
             );  
               $query = new WP_Query($args); 
               if ( $query->have_posts() ) : 
               while ($query->have_posts()) : $query->the_post(); ?>
         <div class="team-inner-box mt-2">
            <div class="team-box-content pb-5">
               <div class="team-inner-boxs">
               <?php the_post_thumbnail(); ?>
            </div>
            <div class="team-inner-bx ps-3">
               <h4 class="mt-4 mb-1">
                  <a href="<?php the_permalink(); ?>">
                  <?php the_title(); ?></a>
               </h4>
               <div class="team-socialbox mt-3 mb-5">                         
                  <?php if(get_post_meta($post->ID,'meta-facebookurl',true) || get_post_meta($post->ID,'meta-twitterurl',true) || get_post_meta($post->ID,'meta-pinterestsurl',true) || get_post_meta($post->ID,'meta-vimeourl',true)){?>
                  <?php if(get_post_meta($post->ID,'meta-facebookurl',true)){?>
                  <a class="" href="<?php echo esc_html(get_post_meta($post->ID,'meta-facebookurl',true)); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
                  <?php } 
                  if(get_post_meta($post->ID,'meta-twitterurl',true)){?>
                  <a class="" href="<?php echo esc_html(get_post_meta($post->ID,'meta-twitterurl',true)); ?>" target="_blank"><i class="fab fa-twitter"></i></a>                              
                  <?php }
                  if(get_post_meta($post->ID,'meta-pinterestsurl',true)){?>
                  <a class="" href="<?php echo esc_html(get_post_meta($post->ID,'meta-pinterestsurl',true)); ?>" target="_blank"><i class="fab fa-pinterest-p"></i></a>                              
                  <?php } 
                  if(get_post_meta($post->ID,'meta-vimeourl',true)){?>
                  <a class="" href="<?php echo esc_html(get_post_meta($post->ID,'meta-vimeourl',true)); ?>" target="_blank"><i class="fab fa-vimeo-v"></i></a>
                  <?php } 
               }?>
               </div>
            </div>
            </div>
            
         </div>
         <?php $i++; endwhile; endif; ?>
      </div>
   </div>
</div>
</div>
</section>