<?php 
   /**
    * Template part for displaying Our client
    *
    * @package vw-black-and-white-pro
    */ 
   
   $section_hide = get_theme_mod( 'vw_black_and_white_pro_our_client_enable' );
   if ( 'Disable' == $section_hide ) {
    return;
   }
   
   if( get_theme_mod('vw_black_and_white_pro_our_client_bgcolor','') ) {
    $our_client_backg = 'background-color:'.esc_attr(get_theme_mod('vw_black_and_white_pro_our_client_bgcolor','')).';';
   }elseif( get_theme_mod('vw_black_and_white_pro_our_client_bgimage','') ){
    $our_client_backg = 'background-image:url(\''.esc_url(get_theme_mod('vw_black_and_white_pro_our_client_bgimage')).'\')';
   }else{
    $our_client_backg='';
   }
   
   $img_bg = get_theme_mod('vw_black_and_white_pro_our_client_bgimage_setting',true);
   
   ?>
<section id="our-client" style="<?php echo esc_attr($our_client_backg);?>" class="mt-5 pt-5 pb-5 <?php echo esc_attr($img_bg); ?>">
   <div class="container">
   <div class="our-client-box row br-top-bottom br-tops">
      <div class="col-lg-12">
      <div class="owl-carousel pt-5">
         <?php
            $i=1;
            $args = array(
              'post_type' => 'our-client',
              'post_status' => 'publish',
              'posts_per_page' => get_theme_mod('vw_black_and_white_pro_our_client_number'),
             );  
               $query = new WP_Query($args); 
               if ( $query->have_posts() ) : 
               while ($query->have_posts()) : $query->the_post(); ?>
                  <div class="row">
                  <div class="col-lg-5">
                     <div class="client-inner-boxs">
                       <?php the_post_thumbnail(); ?>
                      </div>
                   </div>
                  <div class="col-lg-6 offset-lg-1 client-sec-col pt-5 mt-5">
                     <div class="quotes-imgs">
                       <i class="<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_our_client_quotes1')); ?>"></i>
                        <h2 class="mt-2">
                         <span class="first-heads"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_our_client_main_heading')); ?></span>
                         <span class="first-client-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_our_client_color-head1')); ?>
                        </span>
                         <span class="sec-client-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_our_client_color-head2')); ?>
                        </span>
                        <p class="client-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_our_client_color-head3')); ?></p>
                        </h2>
                       <i class="<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_our_client_quotes2')); ?>"></i>
                      </div>
                   <div class="client-box-content">
                     <div class="client-inner-bx">
                       <h4 class="mt-5 pt-3 mb-3">
                         <a href="<?php the_permalink(); ?>">
                           <?php the_title(); ?></a>
                       </h4>
                       <p class="mb-2 client-desg"><?php echo esc_html(get_post_meta($post->ID,'meta-client-designation',true)); ?> 
                       </p>
                      <p class="mb-1 client-desc"><?php echo esc_html(get_post_meta($post->ID,'meta-client-description',true)); ?> 
                     </p>
                   </div>
                   </div>
                  </div>
               </div>
            <?php $i++; endwhile; endif; ?>
        </div>
     </div>
     </div>
  </div>
</section>