<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package vw-black-and-white-pro
 */

get_header(); 
get_template_part('template-parts/banner');
?>

<div class="container">
	<div class="middle-align">
		<?php if (defined('VWBC_VERSION')){
        	echo do_shortcode( '[vw-breadcrumb]' );
    	} ?>
		<div class="row mt-5">
			<div class="col-lg-8 col-sm-6 col-md-12">
				<div class="row search-result">
					<?php if ( have_posts() ) : ?>
						<?php while ( have_posts() ) : the_post();
							get_template_part('template-parts/post/post-content');
						endwhile; ?>
						<div class="navigation">
							<?php // Previous/next page navigation.
							  the_posts_pagination( array(
								  'prev_text'          => __( 'Previous page', 'vw-black-and-white-pro' ),
								  'next_text'          => __( 'Next page', 'vw-black-and-white-pro' ),
								  'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'vw-black-and-white-pro' ) . ' </span>',
							  )); ?>
						</div>
					<?php else : ?>
						<?php get_template_part( 'no-results', 'search' ); ?>
					<?php endif; ?>
				</div>
			</div>
			<div class="col-lg-4 col-md-12 col-sm-6" id="vw-sidebar">
				<?php dynamic_sidebar('sidebar-1'); ?>
			</div>
			<div class="clearfix"></div>
		</div>
	</div>
</div>
<?php get_footer(); ?>