<?php 
   /**
    * Page Template for displaying Contact Information
    *
    * @package grocery-ecommerce-pro
    */ 
   get_header();
 get_template_part( 'template-parts/banner' );
   $section_hide = get_theme_mod( 'vw_black_and_white_pro_contact_information_enable' );
   if ( 'Disable' == $section_hide ) {
    return;
   }
   
   if( get_theme_mod('vw_black_and_white_pro_contact_information_bgcolor','') ) {
    $contact_information_backg = 'background-color:'.esc_attr(get_theme_mod('vw_black_and_white_pro_contact_information_bgcolor','')).';';
   }elseif( get_theme_mod('vw_black_and_white_pro_contact_information_bgimage','') ){
    $contact_information_backg = 'background-image:url(\''.esc_url(get_theme_mod('vw_black_and_white_pro_contact_information_bgimage')).'\')';
   }else{
    $contact_information_backg='';
   }
   
   $img_bg = get_theme_mod('vw_black_and_white_pro_contact_information_bgimage_setting',true);
   
   ?>
<section id="contact-information" style="<?php echo esc_attr($contact_information_backg);?>" class="<?php echo esc_attr($img_bg); ?> mt-5 pt-4 pb-5 mb-3" >
   <div class="container" id="contact-information-box">
      <div class="row">
         <div class="col-lg-7 col-md-12 col-sm-12 col-12 p-5 me-lg-0 pe-lg-0 contact-boxes">
            <div class="contact-info-box p-4">
               <h2 class="mt-lg-3">
                  <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_main_heading')); ?>
               </h2>
               <p class="me-lg-5 pe-lg-5 contact-heads">
                  <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_main_text')); ?>
               </p>
               <div class="row col-12 mt-3">
               <div class="col-xl-1 col-lg-2 col-md-3 col-sm-3 col-3 mt-1">
                  <i class=" <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_icon_phones')); ?>"></i>
               </div>
               <div class="col-xl-11 col-lg-10 col-md-9 col-sm-9 col-9 ms-lg-0 ps-lg-0">
                  <?php $vw_black_and_white_pro_contact_information_contact_option = get_theme_mod( 'vw_black_and_white_pro_contact_information_options','Call');
                        if($vw_black_and_white_pro_contact_information_contact_option == 'Call'){ ?>
                           <a href='tel:<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_phone_one')); ?>' target='_blank'>
                              <p class="m-0 phn-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_phone_one')); ?></p>
                           </a>
                          
                           <?php } else if ($vw_black_and_white_pro_contact_information_contact_option == 'Whatsapp') { ?>
                           <a href='https://wa.me/<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_phone_one')); ?>' target='_blank'>
                           <p class="m-0 phn-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_phone_one')); ?></p>
                           </a>
                          
                  <?php } ?>  
               </div>
            </div>
               <div class="row col-12 mt-2">
               <div class="col-xl-1 col-lg-2 col-md-3 col-sm-3 col-3 mt-1">
                  <i class=" <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_icon_emailss')); ?>">
                  </i>
               </div>
               <div class="col-xl-11 col-lg-10 col-md-9 col-sm-9 col-9 ms-lg-0 ps-lg-0">
                  <a href="mailto:<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_email1')); ?>">
                     <p class="m-0 email-text"><?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_email1')); ?></p>
                  </a>
               </div>
            </div>
            <div class="maps mt-lg-4">
            <?php if ( get_theme_mod('vw_black_and_white_pro_contact_information_address_latitude',true) != "" && get_theme_mod('vw_black_and_white_pro_contact_information_address_longitude',true) != "" ) {?>
               <embed width="100%" height="220" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q=<?php echo esc_attr(get_theme_mod('vw_black_and_white_pro_contact_information_address_latitude','21.145800')); ?>,<?php echo esc_attr(get_theme_mod('vw_black_and_white_pro_contact_information_address_longitude','79.088155')); ?>&hl=es;z=14&amp;output=embed"></embed>
            <?php }?>
            </div>
            <div class="contact-form-right-img text-lg-end">
           <?php if(get_theme_mod('vw_black_and_white_pro_contact_information_img1')!=''){ ?>
               <img src="<?php echo esc_html(get_theme_mod('vw_black_and_white_pro_contact_information_img1')); ?>">
            <?php } ?> 
            </div>
            </div>
         </div>
         <div class="col-lg-5 col-md-12 col-sm-12 col-12 pt-5 pb-5 pe-4 ps-5 contact-main-sec">
            <div class="information-form-box">
            <?php echo do_shortcode(get_theme_mod('vw_black_and_white_pro_contact_information_form_code')); ?>
            </div>
         </div>
      </div>
   </div>
</section>
<?php get_footer();