<?php
/**
 * Template Name:Blog with Left Sidebar
 */


get_header();
get_template_part('template-parts/banner');
$content_type = get_theme_mod( 'vw_black_and_white_pro_post_content_blog','Excerpt Content');
   $excerpt_length="";
   if($content_type=="Excerpt Content"){
     $excerpt_length=get_theme_mod( 'vw_black_and_white_pro_excerpt_length',25);
   }
  ?>

<?php do_action('vw_black_and_white_pro_before_blog'); ?>

<div id="blog-left-sidebar">
	<div class="container mt-5">
		<?php if (defined('VWBC_VERSION')){
	        echo do_shortcode( '[vw-breadcrumb]' );
	    } ?>
	    <div class="middle-align">
		    <div class="row">
				<div class="col-lg-4 mt-5" id="vw-sidebar">
         <?php  dynamic_sidebar('sidebar-2'); ?>
        </div>
				<div class="col-lg-8 content_page">
					<div class="row">
						<?php if ( have_posts() ) : ?>
					      	<?php $vw_paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
								$args = array(
								   'paged' => $vw_paged,
								   'category_name' => get_theme_mod('vw_black_and_white_pro_category_setting'),
								);
								$custom_query = new WP_Query( $args );
								while($custom_query->have_posts()) :
								   $custom_query->the_post(); ?>
								   <div id="single_post" class="col-lg-6 col-md-6 col-sm-12 text-center text-sm-center text-md-start text-lg-start three-col mt-5">
      <div class="postbox">
         <div class="postpic">
            <div class="post_pic_inner">
               <?php if(get_theme_mod("vw_black_and_white_pro_blog_featured_image_enable",true)=='1'){?>
               <?php if (has_post_thumbnail()){ ?>
               <?php the_post_thumbnail(); ?>
               <?php } ?>
               <?php } ?>  
            </div>
            <div class="post-content-box mx-lg-3 mx-md-3 mx-sm-2 mx-2 p-3">
            <h6 class="mb-0"></h6>
            <h4 class="posttitle">
               <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h4>
            <div class="post-hide-sec">
               <div class="mt-4 mb-3 post-text">
                  <?php if($content_type=="Excerpt Content"){  ?>
                  <?php $excerpt = get_the_excerpt(); esc_html_e(vw_black_and_white_pro_string_limit_words($excerpt,$excerpt_length),'vw-black-and-white-pro'); ?>
                  <span>
                  <?php echo esc_html(get_theme_mod('vw_black_and_white_pro_button_excerpt_suffix','[...]')); ?>
                  </span>
                  <?php } if($content_type=="Full Content"){  ?>
                  <?php the_content(); ?>
                  <?php } ?>
               </div>
               <a href="<?php the_permalink(); ?>" target="_blank">
               <span data-title="<?php echo esc_html_e('Read More','vw-black-and-white-pro'); ?>"><?php echo esc_html_e('Read More','vw-black-and-white-pro'); ?></span>
               </a>
            </div>
            <div class="row col-12 author-box ms-lg-1 pt-lg-1">
               <div class="col-lg-5 col-md-5 col-sm-12 col-12 text-lg-start p-0">
                  <span class="author-name"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php the_author(); ?></a></span>
               </div>
               <div class="col-lg-7 col-md-7 col-sm-12 col-12 text-lg-end">
                  <span class="blog-entry-date">
                  <i class="far fa-clock"></i>
                  <?php echo esc_html( k99_relative_time()); ?>
                  </span>
               </div>
            </div>
         </div>
         </div>
      </div>
</div>
							<?php
								endwhile; // end of the loop.
								wp_reset_postdata(); ?>
						<?php else : ?>
							<h3><?php _e('Not Found','vw-black-and-white-pro'); ?></h3>
						<?php endif; ?>
					</div>
					<div class="vw-navigation mb-2">
		              	<?php 
							$big = 999999999;
							echo paginate_links( array(
								'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
								'format' => 'paged=%#%',
								'current' =>  (get_query_var('paged') ? get_query_var('paged') : 1),
								'total' => $custom_query->max_num_pages
							) );
						?>
		            </div>
				</div>
		        <div class="clearfix"></div>
		    </div>
	    </div>
	</div>
</div>

<?php do_action('vw_black_and_white_pro_after_blog'); ?>
<?php get_footer(); ?>