<?php
/**
 * The template for displaying index page.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package vw-black-and-white-pro
 */

$banner_img_backg = 'background-image:url(\''.esc_url(get_theme_mod('vw_black_and_white_pro_banner_bgimages')).'\')';
get_header();

?>
<?php do_action( 'vw_black_and_white_pro_after_defaulttitle' ); ?>
<section class="banner-image archive-box-title" style="<?php echo esc_attr($banner_img_backg);?>" class="mt-5">
   <div class="container-fluid py-lg-4">
       <h1 class="text-center mt-lg-5"><?php echo get_the_title() ?></h1>   
   </div>     
</section>
<div class="post-section mt-5">
	<div class="container">
		<div class="row">
			<div class="col-md-8">
				<div class="row">
					<?php while ( have_posts() ) : the_post();
							get_template_part('template-parts/post/post-content');
					endwhile; ?>
				</div>
			  <div class="navigation">
				<?php // Previous/next page navigation.
				  the_posts_pagination( array(
					  'prev_text'          => __( 'Previous page', 'vw-black-and-white-pro' ),
					  'next_text'          => __( 'Next page', 'vw-black-and-white-pro' ),
					  'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'vw-black-and-white-pro' ) . ' </span>',
				  )); ?>
			  </div>
			</div>
			<div class="col-md-4" id="vw-sidebar"><?php dynamic_sidebar( 'sidebar-1' ); ?></div>
		</div>
	</div>
</div>
<?php get_footer(); ?>