<?php
/**
 * vw-black-and-white-pro Theme Customizer
 *
 * @package vw-black-and-white-pro
 */
/**
 * Loads custom control for layout settings
 */
function vw_black_and_white_pro_custom_controls() {
    require_once get_template_directory() . '/inc/customize/controls/admin/customize-texteditor-control.php';
    require_once get_template_directory() . '/inc/customize/controls/custom-controls.php';
    
}
add_action( 'customize_register', 'vw_black_and_white_pro_custom_controls' );
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function vw_black_and_white_pro_customize_register( $wp_customize ) {

    $wp_customize->selective_refresh->add_partial( 'blogname', array(
        'selector' => '.vw-resume-logo a',
        'render_callback' => 'twentyfifteen_customize_partial_blogname',
    ) );
    $wp_customize->selective_refresh->add_partial( 'blogdescription', array(
        'selector' => '.logo-text p',
        'render_callback' => 'twentyfifteen_customize_partial_blogdescription',
    ) );

    $wp_customize->add_setting('vw_black_and_white_pro_display_title',array(
        'default' => 'false',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('vw_black_and_white_pro_display_title',array(
        'type' => 'checkbox',
        'label' => __('Show Title','vw-black-and-white-pro'),
        'section' => 'title_tagline',
    ));
    $wp_customize->add_setting('vw_black_and_white_pro_display_tagline',array(
        'default' => 'false',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('vw_black_and_white_pro_display_tagline',array(
        'type' => 'checkbox',
        'label' => __('Show Tagline','vw-black-and-white-pro'),
        'section' => 'title_tagline',
    ));
    
    //add home page setting pannel
    $wp_customize->add_panel( 'vw_black_and_white_pro_panel_id', array(
        'priority' => 10,
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => __( 'VW Theme Settings', 'vw-black-and-white-pro' ),
        'description' => __( 'Description of what this panel does.', 'vw-black-and-white-pro' ),
    ) );

    
    $font_array = array(
        '' => __( 'No Fonts', 'vw-black-and-white-pro' ),
        'Abril Fatface' => __( 'Abril Fatface', 'vw-black-and-white-pro' ),
        'Acme' => __( 'Acme', 'vw-black-and-white-pro' ),
        'Anton' => __( 'Anton', 'vw-black-and-white-pro' ),
        'Architects Daughter' => __( 'Architects Daughter', 'vw-black-and-white-pro' ),
        'Arimo' => __( 'Arimo', 'vw-black-and-white-pro' ),
        'Arsenal' => __( 'Arsenal', 'vw-black-and-white-pro' ),
        'Arvo' => __( 'Arvo', 'vw-black-and-white-pro' ),
        'Alegreya' => __( 'Alegreya', 'vw-black-and-white-pro' ),
        'Alfa Slab One' => __( 'Alfa Slab One', 'vw-black-and-white-pro' ),
        'Averia Serif Libre' => __( 'Averia Serif Libre', 'vw-black-and-white-pro' ),
        'Bangers' => __( 'Bangers', 'vw-black-and-white-pro' ),
        'Boogaloo' => __( 'Boogaloo', 'vw-black-and-white-pro' ),
        'Bad Script' => __( 'Bad Script', 'vw-black-and-white-pro' ),
        'Bitter' => __( 'Bitter', 'vw-black-and-white-pro' ),
        'Bree Serif' => __( 'Bree Serif', 'vw-black-and-white-pro' ),
        'BenchNine' => __( 'BenchNine', 'vw-black-and-white-pro' ),
        'Cabin' => __( 'Cabin', 'vw-black-and-white-pro' ),
        'Cardo' => __( 'Cardo', 'vw-black-and-white-pro' ),
        'Courgette' => __( 'Courgette', 'vw-black-and-white-pro' ),
        'Cherry Swash' => __( 'Cherry Swash', 'vw-black-and-white-pro' ),
        'Cormorant Garamond' => __( 'Cormorant Garamond', 'vw-black-and-white-pro' ),
        'Crimson Text' => __( 'Crimson Text', 'vw-black-and-white-pro' ),
        'Cuprum' => __( 'Cuprum', 'vw-black-and-white-pro' ),
        'Cookie' => __( 'Cookie', 'vw-black-and-white-pro' ),
        'Chewy' => __( 'Chewy', 'vw-black-and-white-pro' ),
        'Days One' => __( 'Days One', 'vw-black-and-white-pro' ),
        'Dosis' => __( 'Dosis', 'vw-black-and-white-pro' ),
        'Economica' => __( 'Economica', 'vw-black-and-white-pro' ),
        'Fredoka One' => __( 'Fredoka One', 'vw-black-and-white-pro' ),
        'Fjalla One' => __( 'Fjalla One', 'vw-black-and-white-pro' ),
        'Francois One' => __( 'Francois One', 'vw-black-and-white-pro' ),
        'Frank Ruhl Libre' => __( 'Frank Ruhl Libre', 'vw-black-and-white-pro' ),
        'Gloria Hallelujah' => __( 'Gloria Hallelujah', 'vw-black-and-white-pro' ),
        'Great Vibes' => __( 'Great Vibes', 'vw-black-and-white-pro' ),
        'Handlee' => __( 'Handlee', 'vw-black-and-white-pro' ),
        'Hammersmith One' => __( 'Hammersmith One', 'vw-black-and-white-pro' ),
        'Inconsolata' => __( 'Inconsolata', 'vw-black-and-white-pro' ),
        'Indie Flower' => __( 'Indie Flower', 'vw-black-and-white-pro' ),
        'IM Fell English SC' => __( 'IM Fell English SC', 'vw-black-and-white-pro' ),
        'Julius Sans One' => __( 'Julius Sans One', 'vw-black-and-white-pro' ),
        'Josefin Slab' => __( 'Josefin Slab', 'vw-black-and-white-pro' ),
        'Josefin Sans' => __( 'Josefin Sans', 'vw-black-and-white-pro' ),
        'Kanit' => __( 'Kanit', 'vw-black-and-white-pro' ),
        'Lobster' => __( 'Lobster', 'vw-black-and-white-pro' ),
        'Lato' => __( 'Lato', 'vw-black-and-white-pro' ),
        'Lora' => __( 'Lora', 'vw-black-and-white-pro' ),
        'Libre Baskerville' => __( 'Libre Baskerville', 'vw-black-and-white-pro' ),
        'Lobster Two' => __( 'Lobster Two', 'vw-black-and-white-pro' ),
        'Merriweather' => __( 'Merriweather', 'vw-black-and-white-pro' ),
        'Monda' => __( 'Monda', 'vw-black-and-white-pro' ),
        'Montserrat' => __( 'Montserrat', 'vw-black-and-white-pro' ),
        'Muli' => __( 'Muli', 'vw-black-and-white-pro' ),
        'Marck Script' => __( 'Marck Script', 'vw-black-and-white-pro' ),
        'Noto Serif' => __( 'Noto Serif', 'vw-black-and-white-pro' ),
        'Open Sans' => __( 'Open Sans', 'vw-black-and-white-pro' ),
        'Oswald' =>__( 'Oswald', 'vw-black-and-white-pro' ),
        'Overpass' => __( 'Overpass', 'vw-black-and-white-pro' ),
        'Overpass Mono' => __( 'Overpass Mono', 'vw-black-and-white-pro' ),
        'Oxygen' => __( 'Oxygen', 'vw-black-and-white-pro' ),
        'Orbitron' => __( 'Orbitron', 'vw-black-and-white-pro' ),
        'Patua One' => __( 'Patua One', 'vw-black-and-white-pro' ),
        'Pacifico' => __( 'Pacifico', 'vw-black-and-white-pro' ),
        'Padauk' => __( 'Padauk', 'vw-black-and-white-pro' ),
        'Playball' => __( 'Playball', 'vw-black-and-white-pro' ),
        'Playfair Display' => __( 'Playfair Display', 'vw-black-and-white-pro' ),
        'PT Sans' => __( 'PT Sans', 'vw-black-and-white-pro' ),
        'Philosopher' => __( 'Philosopher', 'vw-black-and-white-pro' ),
        'Permanent Marker' => __( 'Permanent Marker', 'vw-black-and-white-pro' ),
        'Poiret One' => __( 'Poiret One', 'vw-black-and-white-pro' ),
        'Quicksand' => __( 'Quicksand', 'vw-black-and-white-pro' ),
        'Quattrocento Sans' => __( 'Quattrocento Sans', 'vw-black-and-white-pro' ),
        'Raleway' => __( 'Raleway', 'vw-black-and-white-pro' ),
        'Rubik' => __( 'Rubik', 'vw-black-and-white-pro' ),
        'Rokkitt' => __( 'Rokkitt', 'vw-black-and-white-pro' ),
        'Russo One' => __( 'Russo One', 'vw-black-and-white-pro' ),
        'Righteous' => __( 'Righteous', 'vw-black-and-white-pro' ),
        'Slabo' => __( 'Slabo', 'vw-black-and-white-pro' ),
        'Source Sans Pro' => __( 'Source Sans Pro', 'vw-black-and-white-pro' ),
        'Shadows Into Light Two' => __( 'Shadows Into Light Two', 'vw-black-and-white-pro'),
        'Shadows Into Light' => __( 'Shadows Into Light', 'vw-black-and-white-pro' ),
        'Sacramento' => __( 'Sacramento', 'vw-black-and-white-pro' ),
        'Shrikhand' => __( 'Shrikhand', 'vw-black-and-white-pro' ),
        'Tangerine' => __( 'Tangerine', 'vw-black-and-white-pro' ),
        'Ubuntu' => __( 'Ubuntu', 'vw-black-and-white-pro' ),
        'VT323' => __( 'VT323', 'vw-black-and-white-pro' ),
        'Varela Round' => __( 'Varela Round', 'vw-black-and-white-pro' ),
        'Vampiro One' => __( 'Vampiro One', 'vw-black-and-white-pro' ),
        'Vollkorn' => __( 'Vollkorn', 'vw-black-and-white-pro' ),
        'Volkhov' => __( 'Volkhov', 'vw-black-and-white-pro' ),
        'Yanone Kaffeesatz' => __( 'Yanone Kaffeesatz', 'vw-black-and-white-pro' )
    );
    

    require_once get_template_directory() . '/inc/customize/controls/customize-repeater/customize-repeater.php';
    require_once get_template_directory() . '/inc/customize/controls/button-controls.php';
    require_once get_template_directory() . '/inc/customize/controls/social-icons/social-icon-picker.php';
    require_once get_template_directory() . '/inc/customize/controls/slider-line-control/slider-line-control.php';
    require_once get_template_directory() . '/inc/customize/controls/customizer-notice/class/customizer-notice.php';
    require_once get_template_directory() . '/inc/customize/controls/customizer-seperator/class/customizer-seperator.php';
    require_once get_template_directory() . '/inc/customize/controls/customizer-text-radio-button/class/customizer-text-radio-button.php';
   
 if ( (ThemeWhizzie::get_the_validation_status() === 'true') && (ThemeWhizzie::get_the_suspension_status() == 'false') ) {
    //general Settings
    require_once get_template_directory(). '/inc/customize/sections/customizer-custom-variables.php';
    //Header
    require_once get_template_directory(). '/inc/customize/sections/customizer-part-header.php';
    //Slider
    require_once get_template_directory() . '/inc/customize/sections/customizer-part-slide.php';
    //Home page sections
    require_once get_template_directory(). '/inc/customize/sections/customizer-part-home.php';
    //Footer
    require_once get_template_directory(). '/inc/customize/sections/customizer-part-footer.php';
 }
}
add_action( 'customize_register', 'vw_black_and_white_pro_customize_register' );
//Integer
function vw_black_and_white_pro_sanitize_integer( $input ) {
    if( is_numeric( $input ) ) {
        return intval( $input );
    }
}
load_template( trailingslashit( get_template_directory() ) . '/inc/logo/logo-resizer.php' );
/**
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class vw_black_and_white_pro_customize {
    /**
     * Returns the instance.
     *
     * @since  1.0.0
     * @access public
     * @return object
     */
    public static function get_instance() {
        static $instance = null;
        if ( is_null( $instance ) ) {
            $instance = new self;
            $instance->setup_actions();
        }
        return $instance;
    }
    /**
     * Constructor method.
     *
     * @since  1.0.0
     * @access private
     * @return void
     */
    private function __construct() {}
    /**
     * Sets up initial actions.
     *
     * @since  1.0.0
     * @access private
     * @return void
     */
    private function setup_actions() {
        // Register panels, sections, settings, controls, and partials.
        add_action( 'customize_register', array( $this, 'sections' ) );
         add_action( 'customize_register', array( $this, 'mobileApp' ) );
        // Register scripts and styles for the controls.
        add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
    }
    /**
     * Sets up the customizer sections.
     *
     * @since  1.0.0
     * @access public
     * @param  object  $manager
     * @return void
     */
    public function sections( $manager ) {
        // Load custom sections.
        load_template( trailingslashit( get_template_directory() ) . '/inc/review-section.php' );
        // Register custom section types.
        $manager->register_section_type( 'vw_black_and_white_pro_customize_reviews_and_testimonials' );
        // Register sections.
        $manager->add_section(
            new vw_black_and_white_pro_customize_reviews_and_testimonials(
                $manager,
                'example_review',
                array(
                    'title'    => esc_html__( 'Review & Testimonial', 'vw-black-and-white-pro' ),
                    'reviews_and_testimonials_text' => esc_html__( 'Rate Us', 'vw-black-and-white-pro' ),
                    'reviews_and_testimonials_url'  => 'https://www.vwthemes.com/topic/reviews-and-testimonials/',
                    'priority'   => 1,
                )
            )
        );
    }

    public function mobileApp( $manager ) {
        // Load custom sections.
        load_template( trailingslashit( get_template_directory() ) . '/inc/review-section.php' );
        // Register custom section types.
        $manager->register_section_type( 'vw_black_and_white_pro_customize_reviews_and_testimonials' );
        // Register sections.
        $manager->add_section(
            new vw_black_and_white_pro_customize_reviews_and_testimonials(
                $manager,
                'example_2',
                array(
                    'title'    => esc_html__( 'Theme Bundle', 'vw-black-and-white-pro' ),
                    'reviews_and_testimonials_text' => esc_html__( 'Buy Now', 'vw-black-and-white-pro' ),
                    'reviews_and_testimonials_url'  => 'https://www.vwthemes.com/premium/theme-bundle/',
                    'priority'   => 2,
                )
            )
        );
    }
    /**
     * Loads theme customizer CSS.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function enqueue_control_scripts() {
       wp_enqueue_script( 'vw-black-and-white-pro-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );
        wp_enqueue_style( 'vw-black-and-white-pro-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/css/customize-controls.css' );
    }
}
// Doing this customizer thang!
vw_black_and_white_pro_customize::get_instance();