/**
 * NOTE: A minified copy of this script will be generated by grunt. Only the minified file will be included in zipped releases.
 *
 * @file Handles reCAPTCHA on the frontend.
 * @since 4.0.7
 */


(function($) {
  window.etCore          = window.etCore || {};
  window.etCore.api      = window.etCore.api || {};
  window.etCore.api.spam = window.etCore.api.spam || {};

  /**
   * Recaptcha
   *
   * @since??
   *
   * @memberof window.etCore.api.spam
   */
  window.etCore.api.spam.recaptcha = $.extend( et_core_api_spam_recaptcha, {

    _bindMethods: function(target) {
      Object.keys(target).forEach(function(prop) {
        if (target.hasOwnProperty(prop) && 'function' === typeof target[prop]) {
          target[prop] = target[prop].bind(target);
        }
      });
    },

    init: function() {
      this._bindMethods(this);

      if (this.isEnabled()) {
        // Execute the default page-level action
        window.grecaptcha && grecaptcha.execute(this.site_key, this.page_action);
      }
    },

    isEnabled: function() {
      return !! (this.site_key && window.grecaptcha);
    },

    /**
     * Score an interaction to determine whether or not it's a bot.
     *
     * @since 4.0.7
     *
     * @param {string} action The name of the action being performed.
     *
     * @return {Promise<string>} Interaction token to be verified on server.
     */
    interaction: function(action) {
      if (! this.isEnabled()) {
        return Promise.resolve('');
      }

      return grecaptcha.execute(this.site_key, { action: action });
    }
  } );

  window.grecaptcha && grecaptcha.ready(function() {
    window.etCore.api.spam.recaptcha.init();
  });

})(jQuery);
