<?php /*

  This file is part of a child theme called Divi-Child.
  Functions in this file will be loaded before the parent theme's functions.
  For more information, please read
  https://developer.wordpress.org/themes/advanced-topics/child-themes/

*/

// this code loads the parent's stylesheet (leave it in place unless you know what you're doing)

function your_theme_enqueue_styles() {

    $parent_style = 'parent-style';

    wp_enqueue_style( $parent_style, 
      get_template_directory_uri() . '/style.css'); 

    wp_enqueue_style( 'child-style', 
      get_stylesheet_directory_uri() . '/style.css', 
      array($parent_style), 
      wp_get_theme()->get('Version') 
    );
}

add_action('wp_enqueue_scripts', 'your_theme_enqueue_styles');

/*  Add your own functions below this line.
    ======================================== */ 

// DSS : Cllear the image Title & Alt on upload
function my_set_image_meta_upon_image_upload($post_ID)
{if (wp_attachment_is_image($post_ID)) {
$my_image_meta = array('ID' => $post_ID, 'post_title' => '',); 
update_post_meta($post_ID, '_wp_attachment_image_alt', '');
wp_update_post($my_image_meta);}} add_action('add_attachment', 'my_set_image_meta_upon_image_upload');

// DSS : Media Library Enable Infinite Scrolling
add_filter( 'media_library_infinite_scrolling', '__return_true' );