<?php echo et_core_intentionally_unescaped( $wrapper_before, 'html' ); ?>
	<?php echo et_core_intentionally_unescaped( $field_label, 'html' ); ?>
	<?php echo et_core_intentionally_unescaped( $field_before, 'html' ); ?>
		<?php

		$req_class   = '';
		$parsley_req = '';
		if ( ! empty( $field['required'] ) ) {
			$req_class   = ' option-required';
			$parsley_req = 'data-parsley-required="true" data-parsley-group="' . esc_attr( $field_id ) . '" data-parsley-multiple="' . esc_attr( $field_id ) . '"';
		}

		$field_value = Caldera_Forms_Field_Util::find_select_field_value( $field, $field_value );


		if ( ! empty( $field['config']['option'] ) ) {


			foreach ( $field['config']['option'] as $option_key => $option ) {
				if ( ! isset( $option['value'] ) ) {
					$option['value'] = $option['label'];
				}
				if ( ! empty( $option['disabled'] ) ) {
					$disabled[ $option_key ] = true;
				}
				?>
				<?php if ( empty( $field['config']['inline'] ) ) { ?>
					<div class="checkbox">
				<?php } ?>

				<label data-label class="dsm-checkbox
				<?php
				if ( ! empty( $field['config']['inline'] ) ) {
					?>
					checkbox-inline<?php } ?>"
						for="<?php echo esc_attr( $field_id . '_' . $option_key ); ?>"
				>
							<input
								<?php echo et_core_intentionally_unescaped( $parsley_req, 'html' ); ?>
								type="checkbox"
								data-label="<?php echo esc_attr( $option['label'] ); ?>"
								data-field="<?php echo esc_attr( $field_base_id ); ?>"
								id="<?php echo esc_attr( Caldera_Forms_Field_Util::opt_id_attr( $field_id, $option_key ) ); ?>"
								class="<?php echo esc_attr( $field_id . $req_class ); ?>"
								name="<?php echo esc_attr( $field_name ); ?>[<?php echo esc_attr( $option_key ); ?>]"
								value="<?php echo esc_attr( $option['value'] ); ?>"
								<?php
								if ( Caldera_Forms_Field_Util::is_checked_option( $option['value'], (array) $field_value ) ) {
									?>
									checked="checked"<?php } ?>
								data-type="checkbox"
								data-checkbox-field="<?php echo esc_attr( $field_id ); ?>"
								<?php
								if ( isset( $disabled[ $option_key ] ) && $disabled[ $option_key ] === true ) {
									?>
									disabled<?php } ?>
								data-calc-value="<?php echo esc_attr( Caldera_Forms_Field_Util::get_option_calculation_value( $option, $field, $form ) ); ?>"
							>
				<span class="dsm-cf-checkbox"></span><?php echo et_core_intentionally_unescaped( $option['label'], 'html' ); ?></label>
				<?php if ( empty( $field['config']['inline'] ) ) { ?>
					</div>
				<?php } ?>
				<?php
			}
		}
		?>
		<?php echo et_core_intentionally_unescaped( $field_caption, 'html' ); ?>
	<?php echo et_core_intentionally_unescaped( $field_after, 'html' ); ?>
<?php echo et_core_intentionally_unescaped( $wrapper_after, 'html' ); ?>
